/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionEntry;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionRepository;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionRepository$LessThan$;
import com.xebialabs.xlrelease.storage.domain.JobEntryRef;
import com.xebialabs.xlrelease.storage.domain.StorageEntryRef;
import com.xebialabs.xlrelease.storage.service.StorageService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.net.URI;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.slf4j.Marker;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.collection.mutable.Buffer;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Service
@ScalaSignature(bytes="\u0006\u0005m3Aa\u0002\u0005\u0001#!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003)\u0011!\u0001\u0004A!A!\u0002\u0013\t\u0004\"\u0002\u001d\u0001\t\u0003I\u0004\"B \u0001\t\u0003\u0001\u0005\"B%\u0001\t\u0013Q%\u0001\b+bg.,\u00050Z2vi&|g\u000eT8h!V\u0014x-Z*feZL7-\u001a\u0006\u0003\u0013)\tqa]3sm&\u001cWM\u0003\u0002\f\u0019\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u001b9\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003=\t1aY8n\u0007\u0001\u00192\u0001\u0001\n\u0019!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fMB\u0011\u0011DH\u0007\u00025)\u00111\u0004H\u0001\u0006g24GG\u001b\u0006\u0002;\u0005AqM]5{u2,G-\u0003\u0002 5\t9Aj\\4hS:<\u0017!\u0003=me\u000e{gNZ5h!\t\u0011S%D\u0001$\u0015\t!#\"\u0001\u0004d_:4\u0017nZ\u0005\u0003M\r\u0012\u0011\u0002\u00177s\u0007>tg-[4\u0002/Q\f7o[#yK\u000e,H/[8o%\u0016\u0004xn]5u_JL\bCA\u0015/\u001b\u0005Q#BA\u0016-\u0003\u0011awnZ:\u000b\u00055R\u0011!C:dQ\u0016$W\u000f\\3s\u0013\ty#FA\fUCN\\W\t_3dkRLwN\u001c*fa>\u001c\u0018\u000e^8ss\u0006q1\u000f^8sC\u001e,7+\u001a:wS\u000e,\u0007C\u0001\u001a7\u001b\u0005\u0019$BA\u00055\u0015\t)$\"A\u0004ti>\u0014\u0018mZ3\n\u0005]\u001a$AD*u_J\fw-Z*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\tibTH\u0010\t\u0003w\u0001i\u0011\u0001\u0003\u0005\u0006A\u0011\u0001\r!\t\u0005\u0006O\u0011\u0001\r\u0001\u000b\u0005\u0006a\u0011\u0001\r!M\u0001\u0004eVtGCA!E!\t\u0019\")\u0003\u0002D)\t!QK\\5u\u0011\u0015)U\u00011\u0001G\u0003M!\u0017-_:SKR,g\u000e^5p]B+'/[8e!\t\u0019r)\u0003\u0002I)\t\u0019\u0011J\u001c;\u0002/I,Wn\u001c<f\u000bb,7-\u001e;j_:dunZ#oiJLHCA!L\u0011\u0015ae\u00011\u0001N\u0003\u0015)g\u000e\u001e:z!\tIc*\u0003\u0002PU\t\u0011B+Y:l\u000bb,7-\u001e;j_:,e\u000e\u001e:zQ\t\u0001\u0011\u000b\u0005\u0002S36\t1K\u0003\u0002U+\u0006Q1\u000f^3sK>$\u0018\u0010]3\u000b\u0005Y;\u0016aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003a\u000b1a\u001c:h\u0013\tQ6KA\u0004TKJ4\u0018nY3")
public class TaskExecutionLogPurgeService
implements Logging {
    private final XlrConfig xlrConfig;
    private final TaskExecutionRepository taskExecutionRepository;
    private final StorageService storageService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TaskExecutionLogPurgeService taskExecutionLogPurgeService = this;
        synchronized (taskExecutionLogPurgeService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public void run(int daysRetentionPeriod) {
        long retentionPeriodMillis = Duration$.MODULE$.apply((long)daysRetentionPeriod, TimeUnit.DAYS).toMillis();
        int maxResultCount = this.xlrConfig.jobLog().maxItemsPerCleanup();
        Instant oldestRetentionDate = Instant.now().truncatedTo(ChronoUnit.SECONDS).minus(retentionPeriodMillis, ChronoUnit.MILLIS);
        Buffer removable = CollectionConverters$.MODULE$.ListHasAsScala(this.taskExecutionRepository.find(new TaskExecutionRepository.FinishedTaskAndExecutions(TaskExecutionRepository$LessThan$.MODULE$, oldestRetentionDate), Pageable.ofSize((int)maxResultCount)).getContent()).asScala();
        removable.foreach((Function1 & Serializable)entry -> {
            this.removeExecutionLogEntry(entry);
            return BoxedUnit.UNIT;
        });
    }

    private void removeExecutionLogEntry(TaskExecutionEntry entry) {
        JobEntryRef executionDirectoryRef = new JobEntryRef(URI.create("xlr-local:///jobs/" + entry.taskIdHash() + "/" + entry.executionId()));
        JobEntryRef taskDirectoryRef = new JobEntryRef(URI.create("xlr-local:///jobs/" + entry.taskIdHash()));
        try {
            try {
                boolean rootDirDeleted;
                boolean deleted = this.storageService.delete((StorageEntryRef)executionDirectoryRef);
                if (deleted) {
                    this.logger().trace((Function0 & Serializable)() -> "Removed task execution log directory " + executionDirectoryRef.uri());
                }
                if (rootDirDeleted = this.storageService.deleteIfEmpty((StorageEntryRef)taskDirectoryRef)) {
                    this.logger().trace((Function0 & Serializable)() -> "Removed task log directory " + taskDirectoryRef.uri());
                }
            }
            catch (Throwable e) {
                this.logger().warn((Function0 & Serializable)() -> "Failed to delete task execution log directory: " + e.getMessage());
            }
        }
        finally {
            this.taskExecutionRepository.delete(new TaskExecutionRepository.DeleteWithTaskExecutionEntry(entry));
            this.logger().trace((Function0 & Serializable)() -> "Removed database entry for task execution log [taskIdHash=" + entry.taskIdHash() + "] [executionId=" + entry.executionId() + "]");
        }
    }

    public TaskExecutionLogPurgeService(XlrConfig xlrConfig, TaskExecutionRepository taskExecutionRepository, StorageService storageService) {
        this.xlrConfig = xlrConfig;
        this.taskExecutionRepository = taskExecutionRepository;
        this.storageService = storageService;
        Logging.$init$((Logging)this);
    }
}

