package com.xebialabs.deployit.plumbing;

import java.io.IOException;
import javax.servlet.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * This filter is only used to deliberately slow down requests.
 */
public class SlowdownFilter implements Filter {

    private static final Logger logger = LoggerFactory.getLogger(SlowdownFilter.class);

    public static final String MS = "ms";

    private int millisecondsToSlowDown = 0;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        millisecondsToSlowDown = Integer.parseInt(filterConfig.getInitParameter(MS));
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            Thread.sleep(millisecondsToSlowDown);
        } catch (InterruptedException e) {
            logger.error("Slowing down the request was interrupted", e);
        }
        chain.doFilter(request, response);
    }

    @Override
    public void destroy() {
    }
}