/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.PhaseApi;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PhaseVersion;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.PermissionContext;
import com.xebialabs.xlrelease.service.PhaseService;
import com.xebialabs.xlrelease.service.ReleaseService;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class PhaseApiImpl
implements PhaseApi {
    private static final Logger logger = LoggerFactory.getLogger(PhaseApiImpl.class);
    private final PermissionChecker permissions;
    private final PhaseService phaseService;
    private final ReleaseService releaseService;
    private final ReleaseActorService releaseActorService;

    @Autowired
    public PhaseApiImpl(PermissionChecker permissions, PhaseService phaseService, ReleaseService releaseService, ReleaseActorService releaseActorService) {
        this.permissions = permissions;
        this.phaseService = phaseService;
        this.releaseService = releaseService;
        this.releaseActorService = releaseActorService;
    }

    @Timed
    public Phase getPhase(String phaseId) {
        this.permissions.checkView(Ids.releaseIdFrom((String)phaseId));
        return this.phaseService.findById(phaseId);
    }

    @Timed
    public Phase updatePhase(String phaseId, Phase phase) {
        this.permissions.checkEdit(Ids.releaseIdFrom((String)phaseId));
        return this.releaseActorService.updatePhase(phaseId, phase);
    }

    @Timed
    public Phase updatePhase(Phase phase) {
        return this.updatePhase(phase.getId(), phase);
    }

    @Timed
    public Task addTask(String containerId, Task task, Integer position) {
        String releaseId = Ids.releaseIdFrom((String)containerId);
        PermissionContext pc = this.permissions.context();
        pc.checkView(releaseId);
        pc.checkEdit(releaseId);
        pc.checkEditTask(releaseId);
        if (task.isLocked()) {
            pc.checkLockTaskPermission(releaseId);
        }
        if (task.getPrecondition() != null) {
            pc.checkEditPreconditionPermission(releaseId);
        }
        if (task.getFailureHandler() != null || task.isTaskFailureHandlerEnabled() || task.getTaskRecoverOp() != null) {
            pc.checkEditFailureHandlerPermission(releaseId);
        }
        try {
            return this.releaseActorService.createTask(containerId, task, position);
        }
        catch (IllegalArgumentException e) {
            logger.error("Could not add a task to a phase", (Throwable)e);
            throw new Checks.IncorrectArgumentException(e.getMessage(), new Object[0]);
        }
    }

    @Timed
    public List<Phase> searchPhasesByTitle(String phaseTitle, String releaseId) {
        Checks.checkArgument((!Strings.isNullOrEmpty((String)phaseTitle) ? 1 : 0) != 0, (String)"Query parameter phaseTitle must be provided", (Object[])new Object[0]);
        Checks.checkArgument((!Strings.isNullOrEmpty((String)releaseId) ? 1 : 0) != 0, (String)"Query parameter releaseId must be provided", (Object[])new Object[0]);
        Release release = this.releaseService.findById(releaseId);
        this.permissions.checkView(release);
        return release.getPhasesByTitle(phaseTitle);
    }

    @Timed
    public List<Phase> searchPhases(String phaseTitle, String releaseId, PhaseVersion phaseVersion) {
        Checks.checkArgument((!Strings.isNullOrEmpty((String)releaseId) ? 1 : 0) != 0, (String)"Query parameter releaseId must be provided", (Object[])new Object[0]);
        Release release = this.releaseService.findById(releaseId);
        this.permissions.checkView(release);
        List<Phase> filteredPhases = release.getPhasesContainingInTitle(phaseTitle);
        filteredPhases = this.filterPhasesForPhaseVersion(filteredPhases, phaseVersion);
        Collections.reverse(filteredPhases);
        return filteredPhases;
    }

    @Timed
    public Phase addPhase(String releaseId, Phase phase, Integer position) {
        PermissionContext pc = this.permissions.context();
        pc.checkView(releaseId);
        pc.checkEdit(releaseId);
        try {
            return this.releaseActorService.addPhase(releaseId, phase, position);
        }
        catch (IllegalArgumentException e) {
            throw new Checks.IncorrectArgumentException(e.getMessage(), new Object[0]);
        }
    }

    @Timed
    public Phase copyPhase(String phaseIdToCopy, int targetPosition) {
        String releaseId = Ids.releaseIdFrom((String)phaseIdToCopy);
        this.permissions.copyPhase(releaseId);
        try {
            return this.releaseActorService.copyPhase(releaseId, phaseIdToCopy, targetPosition);
        }
        catch (IllegalArgumentException e) {
            throw new Checks.IncorrectArgumentException(e.getMessage(), new Object[0]);
        }
    }

    @Timed
    public Phase addPhase(String releaseId, Phase phase) {
        return this.addPhase(releaseId, phase, null);
    }

    @Timed
    public Phase newPhase() {
        return this.newPhase("New Phase");
    }

    @Timed
    public Phase newPhase(String title) {
        Phase phase = new Phase();
        phase.setTitle(title);
        return phase;
    }

    @Timed
    public void deletePhase(String phaseId) {
        this.permissions.checkEdit(Ids.releaseIdFrom((String)phaseId));
        this.releaseActorService.deletePhase(phaseId);
    }

    private List<Phase> filterPhasesForPhaseVersion(List<Phase> phases, PhaseVersion phaseVersion) {
        if (phaseVersion == null || phaseVersion == PhaseVersion.ALL) {
            return phases;
        }
        return phases.stream().filter(phase -> PhaseVersion.isPhaseVersion((Phase)phase, (PhaseVersion)phaseVersion)).collect(Collectors.toList());
    }
}

