package com.xebialabs.xlrelease.views;

import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import com.xebialabs.xlrelease.api.internal.EffectiveSecurity;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdDeserializer;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdSerializer;
import com.xebialabs.xlrelease.variable.VariableHelper;

import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Maps.newHashMap;
import static com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator.EFFECTIVE_SECURITY;

public class ReleaseTasks {

    @JsonSerialize(using = DomainIdSerializer.class)
    @JsonDeserialize(using = DomainIdDeserializer.class)
    private String id;

    private String title;

    private ReleaseStatus status;

    private List<TaskFullView> tasks = newArrayList();

    private Map<String, String> variables = newHashMap();

    private EffectiveSecurity security;

    public ReleaseTasks() {
    }

    public ReleaseTasks(Release release, List<TaskFullView> tasks) {
        this.title = release.getTitle();
        this.id = release.getId();
        this.tasks = tasks;
        this.status = release.getStatus();
        this.variables = VariableHelper.getUsedStringVariables(release);
        this.security = (EffectiveSecurity) release.get$metadata().get(EFFECTIVE_SECURITY());
    }

    public String getTitle() {
        return title;
    }

    public String getId() {
        return id;
    }

    public List<TaskFullView> getTasks() {
        return tasks;
    }

    public Map<String, String> getVariables() {
        return variables;
    }

    public EffectiveSecurity getSecurity() {
        return security;
    }

    public ReleaseStatus getStatus() {
        return status;
    }
}
