package com.xebialabs.xlrelease.views;

import java.util.Date;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdDeserializer;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdSerializer;

public class PlanItemFullView {
    @JsonSerialize(using = DomainIdSerializer.class)
    @JsonDeserialize(using = DomainIdDeserializer.class)
    protected String id;
    protected String title;
    protected String description;
    protected Date scheduledStartDate;
    protected Date dueDate;
    protected Date startDate;
    protected Date endDate;
    protected String type;
    protected boolean hasBeenStarted;
    protected boolean updatable;
    protected boolean active;
    protected boolean done;
    protected Long plannedDuration;

    protected PlanItemFullView() {
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getScheduledStartDate() {
        return scheduledStartDate;
    }

    public void setScheduledStartDate(Date scheduledStartDate) {
        this.scheduledStartDate = scheduledStartDate;
    }

    public Date getDueDate() {
        return dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(final Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(final Date endDate) {
        this.endDate = endDate;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isHasBeenStarted() {
        return hasBeenStarted;
    }

    public void setHasBeenStarted(final boolean hasBeenStarted) {
        this.hasBeenStarted = hasBeenStarted;
    }

    public boolean isUpdatable() {
        return updatable;
    }

    public void setUpdatable(final boolean updatable) {
        this.updatable = updatable;
    }

    public boolean isActive() {
        return active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isDone() {
        return done;
    }

    public void setDone(final boolean done) {
        this.done = done;
    }

    public Long getPlannedDuration() {
        return plannedDuration;
    }

    public void setPlannedDuration(Long plannedDuration) {
        this.plannedDuration = plannedDuration;
    }
}
