package com.xebialabs.xlrelease.views;

import java.util.Date;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdDeserializer;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdSerializer;

public class DependencyNode {
    @JsonSerialize(using = DomainIdSerializer.class)
    @JsonDeserialize(using = DomainIdDeserializer.class)
    private String id;

    @JsonSerialize(using = DomainIdSerializer.class)
    @JsonDeserialize(using = DomainIdDeserializer.class)
    private String releaseId;

    private String releaseTitle;

    private ReleaseOverviewView release;

    @JsonSerialize(using = DomainIdSerializer.class)
    @JsonDeserialize(using = DomainIdDeserializer.class)
    private String phaseId;

    private String phaseTitle;

    @JsonSerialize(using = DomainIdSerializer.class)
    @JsonDeserialize(using = DomainIdDeserializer.class)
    private String taskId;

    private String taskTitle;

    private String taskColor;

    private String taskIconClass;

    private String taskIconLocation;

    private Flag flag;

    private boolean archived = false;

    private Date startDate;

    private Date endDate;

    private Date scheduledStartDate;

    private Date dueDate;

    public DependencyNode() {}

    public String getReleaseId() {
        return releaseId;
    }

    public void setReleaseId(String releaseId) {
        this.releaseId = releaseId;
    }

    public String getReleaseTitle() {
        return releaseTitle;
    }

    public void setReleaseTitle(String releaseTitle) {
        this.releaseTitle = releaseTitle;
    }

    public String getPhaseId() {
        return phaseId;
    }

    public void setPhaseId(String phaseId) {
        this.phaseId = phaseId;
    }

    public String getPhaseTitle() {
        return phaseTitle;
    }

    public void setPhaseTitle(String phaseTitle) {
        this.phaseTitle = phaseTitle;
    }

    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getTaskTitle() {
        return taskTitle;
    }

    public void setTaskTitle(String taskTitle) {
        this.taskTitle = taskTitle;
    }

    public Flag getFlag() {
        return flag;
    }

    public void setFlag(Flag flag) {
        this.flag = flag;
    }

    public String toNodeId() {
        if (phaseId == null) return releaseId;
        if (taskId == null) return phaseId;
        return taskId;
    }

    public String getId() {
        return id;
    }

    public void setId(final String id) {
        this.id = id;
    }

    public boolean isArchived() {
        return archived;
    }

    public void setArchived(final boolean archived) {
        this.archived = archived;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(final Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(final Date endDate) {
        this.endDate = endDate;
    }

    public Date getScheduledStartDate() {
        return scheduledStartDate;
    }

    public void setScheduledStartDate(final Date scheduledStartDate) {
        this.scheduledStartDate = scheduledStartDate;
    }

    public Date getDueDate() {
        return dueDate;
    }

    public void setDueDate(final Date dueDate) {
        this.dueDate = dueDate;
    }

    public String getTaskColor() {
        return taskColor;
    }

    public DependencyNode setTaskColor(String taskColor) {
        this.taskColor = taskColor;
        return this;
    }

    public String getTaskIconClass() {
        return taskIconClass;
    }

    public DependencyNode setTaskIconClass(String taskIconClass) {
        this.taskIconClass = taskIconClass;
        return this;
    }

    public String getTaskIconLocation() {
        return taskIconLocation;
    }

    public DependencyNode setTaskIconLocation(String taskIconLocation) {
        this.taskIconLocation = taskIconLocation;
        return this;
    }

    public ReleaseOverviewView getRelease() {
        return release;
    }

    public DependencyNode setRelease(ReleaseOverviewView release) {
        this.release = release;
        return this;
    }
}
