package com.xebialabs.xlrelease.upgrade.json;

import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlrelease.upgrade.ImportUpgrade;
import com.xebialabs.xlrelease.upgrade.UpgradeResult;

import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

import java.util.Collections;
import java.util.List;

import static com.google.common.collect.Lists.newArrayList;
import static com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT;

public class XLRelease460RemoveSavedVariableProperties implements ImportUpgrade {

    private static final String VERSION = "4.6.0";
    private static final String REMOVED_PROPERTY_NAME = "savedVariableProperties";
    private static final String TASKS_PROPERTY_NAME = "tasks";

    @Override
    public UpgradeResult performUpgrade(JSONObject template) throws JSONException {
        JSONArray phases = template.getJSONArray("phases");

        for (int i = 0; i < phases.length(); i++) {
            JSONObject phase = phases.getJSONObject(i);
            deepRemovePropertyFrom(phase);
        }

        return new UpgradeResult(true, Collections.emptyList());
    }

    @Override
    public Version getUpgradeVersion() {
        return Version.valueOf(XL_RELEASE_COMPONENT, VERSION);
    }

    private void deepRemovePropertyFrom(JSONObject container) throws JSONException {
        if (container.has(TASKS_PROPERTY_NAME)) {
            JSONArray tasks = container.getJSONArray(TASKS_PROPERTY_NAME);
            for (int j = 0; j < tasks.length(); j++) {
                deepRemovePropertyFrom(tasks.getJSONObject(j));
            }
        }

        if (container.has(REMOVED_PROPERTY_NAME)) {
            container.remove(REMOVED_PROPERTY_NAME);
        }
    }
}
