package com.xebialabs.xlrelease.service

import com.xebialabs.xlrelease.domain.{Release, Task, UserInputTask}

import java.util.{List => JList}

object TaskBackup {
  val BACKUP_NODE_NAME = "$tasksBackup"
  val BACKUP_CI_TYPE_PROPERTY_NAME = "$$configuration.item.type"
}

trait TaskBackup {

  /**
   * Makes a backup of task nodes into a special folder of repository.
   */
  def backupTasks(tasks: JList[Task], releaseToBackup: Release): Unit

  def backupTasks(tasks: JList[Task]): Unit = backupTasks(tasks, null)

  /**
    * Makes a backup of a task nodes into a special location inside the phase node.
    *
    * For example, if the task had id: `Applications/Release1/Phase1/Task1`, it will be backed up at `/Applications/Release1/Phase1/$BACKUP_NODE_NAME/Task1` and copy will be performed including all the subtasks.
    *
    * If the passed task is a subtask, and not a top level task, [[IllegalStateException]] will be thrown.
    */
  def backupTask(task: Task, releaseToBackup: Release): Unit

  def backupTask(task: Task): Unit = backupTask(task, null)
  /**
    * Removes variable with given id from user input task backup node.
    *
    * This is needed when we're deleting a variable from release - otherwise it would still be referenced by backup node and delete will fail.
    */
  def removeVariable(task: UserInputTask, variableId: String): Unit

  /**
    * Restores a task into initial state, like it was in original phase.
    */
  def restoreTask[T <: Task](task: T, originalTaskId: String = null, inMemory: Boolean = false): T

}
