package com.xebialabs.xlrelease.service;

import org.springframework.jmx.export.annotation.ManagedOperation;

public interface FeatureService {

    @ManagedOperation(description = "Service name")
    String name();

    @ManagedOperation(description = "Enable service")
    void enable();

    @ManagedOperation(description = "Disable service")
    void disable();

    @ManagedOperation(description = "Is service enabled")
    boolean isEnabled();

    @ManagedOperation(description = "Stop service")
    default void stop() {
        disable();
    }
}
