package com.xebialabs.xlrelease.script.groovy

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.script.{DefaultScriptService, ScriptLifeCycle, ScriptService, ScriptVariables}
import com.xebialabs.xlrelease.security.PermissionChecker
import com.xebialabs.xlrelease.security.authentication.AuthenticationService
import com.xebialabs.xlrelease.service._
import org.apache.commons.io.FilenameUtils
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
class GroovyScriptService @Autowired()(scriptLifeCycle: ScriptLifeCycle,
                                       groovyScriptExecutor: GroovyScriptExecutor,
                                       authenticationService: AuthenticationService,
                                       releaseService: ReleaseService,
                                       scriptVariables: ScriptVariables,
                                       permissions: PermissionChecker,
                                       commentService: CommentService,
                                       xlrConfig: XlrConfig,
                                       attachmentService: AttachmentService,
                                       configurationVariableService: ConfigurationVariableService,
                                       configurationService: ConfigurationService)
  extends DefaultScriptService(scriptLifeCycle,
    groovyScriptExecutor,
    authenticationService,
    releaseService,
    scriptVariables,
    permissions,
    commentService,
    xlrConfig,
    attachmentService,
    configurationVariableService,
    configurationService) with ScriptService {

  override def engine: String = "groovy"

  override def accepts(filename: String): Boolean = {
    "groovy" == FilenameUtils.getExtension(filename)
  }
}
