package com.xebialabs.xlrelease.script.builder

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.domain.Task
import com.xebialabs.xlrelease.script.{ScriptTimeoutContext, XlrScript, XlrScriptContext}

import scala.jdk.DurationConverters._

class TaskPreconditionScriptContextBuilder(xlrConfig: XlrConfig, task: Task) extends ScriptContextBuilder {
  withScriptApi().withLogger().withExecutionId(task.getExecutionId)
  withPythonSugar().withPythonGlobals().withPythonReleaseApi().withPythonUtilities()

  val timeoutEnabled = xlrConfig.timeouts.preconditionTimeoutEnabled
  val timeoutExecutor = xlrConfig.timeoutExecutorThreadPool
  val timeout = xlrConfig.timeouts.preconditionTimeout.toJava
  val settingsKey = xlrConfig.timeouts.PRECONDITION_TIMEOUT_KEY
  withTimeoutContext(new ScriptTimeoutContext(timeoutEnabled, timeoutExecutor, timeout, settingsKey))

  override protected def doBuild(context: XlrScriptContext): Unit = {
    context.addDomainObjects(safe(task))

    val script = XlrScript.byContent(s"<precondition>${task.getType}[${task.getId}]", task.getPrecondition, wrap = true, checkPermissions = true)
    context.addScript(script)
  }

}