package com.xebialabs.xlrelease.script.builder

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.domain.Task
import com.xebialabs.xlrelease.script.{ScriptTimeoutContext, XlrScript, XlrScriptContext}

import scala.jdk.DurationConverters._

class FailureHandlerScriptContextBuilder(xlrConfig: XlrConfig, task: Task) extends ScriptContextBuilder {
  withScriptApi().withLogger().withExecutionId(task.getExecutionId)
  withPythonSugar().withPythonGlobals().withPythonReleaseApi().withPythonUtilities()
  val timeoutEnabled = true
  val timeoutExecutor = xlrConfig.timeoutExecutorThreadPool
  val timeout = xlrConfig.timeouts.failureHandlerTimeout.toJava
  val settingsKey = xlrConfig.timeouts.FAILURE_HANDLER_TIMEOUT_KEY
  withTimeoutContext(new ScriptTimeoutContext(timeoutEnabled, timeoutExecutor, timeout, settingsKey))

  override def doBuild(context: XlrScriptContext): Unit = {
    context.addDomainObjects(safe(task))

    val script = XlrScript.byContent(s"<failure_handler>${task.getType}[${task.getId}]", task.getFailureHandler, wrap = true, checkPermissions = true)
    context.addScript(script)
  }

}