package com.xebialabs.xlrelease.scheduler.workers

import com.xebialabs.xlrelease.actors.ReleaseActorService
import com.xebialabs.xlrelease.scheduler.workers.Worker._
import com.xebialabs.xlrelease.scheduler.{Job, TaskJob}
import com.xebialabs.xlrelease.user.User.SYSTEM
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

@Component
class UnhandledWorker(releaseActorService: ReleaseActorService) extends Worker with Logging {

  override def execute: ExecuteJob = {
    case taskJob: TaskJob[_] =>
      logger.error(s"Found unhandled job $taskJob")
      UnhandledTaskExecutionResult(taskJob.taskRef.getTaskId, taskJob.taskRef.getExecutionId)
    case job: Job =>
      UnhandledExceptionExecutionResult(s"Unhandled job $job")
  }

  override def getOrder: Int = Integer.MAX_VALUE

  override def processResult: ProcessJobResult = {
    case result: UnhandledExecutionResult => result match {
      case UnhandledTaskExecutionResult(taskId, _) =>
        releaseActorService.failTask(taskId, "Unable to find job worker", SYSTEM, None)
      case UnhandledExceptionExecutionResult(message) =>
        throw new IllegalArgumentException(message)
    }
  }
}
