package com.xebialabs.xlrelease.health

import com.xebialabs.xlplatform.cluster.NodeState
import com.xebialabs.xlrelease.actors.initializer.ActorSystemInitializer
import org.springframework.stereotype.Controller
import javax.ws.rs._
import javax.ws.rs.core.{MediaType, Response}

@Path("/ha/health")
@Controller
class HealthCheck(actorSystemInitializer: ActorSystemInitializer) {

  @HEAD
  @GET
  @Produces(Array(MediaType.APPLICATION_JSON))
  def health(): Response = {
    if (NodeState.isActive && actorSystemInitializer.isInitializationCompleted) {
      Response.ok("{ \"status\": \"OK\" }").build()
    } else {
      Response.status(404).entity("I'm not here, see my friend").build()
    }
  }
}
