package com.xebialabs.xlrelease.features.settings

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.xlrelease.configuration.FeatureSettings
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty

import scala.beans.BeanProperty

@Metadata(label = "Permission settings",
  description = "Flags to control permission checks. Consult support before changing this setting."
)
class PermissionCheckFeatureSettings extends FeatureSettings {
  @BeanProperty
  @XLProperty(defaultValue = "Incubating",
    isTransient = true,
    hidden = true,
    readonly = true)
  var category: String = _

  @BeanProperty
  @XLProperty(label = "Use cache",
    description = "Use internal cache mechanism when checking permissions",
    category = "input",
    defaultValue = "true")
  var usePermissionChecksWithCache: Boolean = _
}
