package com.xebialabs.xlrelease.events

import java.util.{List => JList}
import scala.jdk.CollectionConverters._

object XLReleaseOperations {

  def runActionInterceptors(operations: JList[XLReleaseOperation])(implicit eventBus: XLReleaseEventBus): Unit = {
    operations.asScala
      .filter(_.action != null)
      .foreach(operation => eventBus.publishAndFailOnError(operation.action))
  }

  def publishEvents(operations: JList[XLReleaseOperation])(implicit eventBus: XLReleaseEventBus): Unit = {
    operations.asScala
      .filter(_.event != null)
      .foreach(operation => eventBus.publish(operation.event))
  }

}
