package com.xebialabs.xlrelease.domain.tasks.notification;

import java.util.Set;
import org.springframework.stereotype.Component;

import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.NotificationTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.tasks.TaskUpdateDirective;
import com.xebialabs.xlrelease.domain.tasks.task.DefaultTaskUpdater;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils;

import static com.xebialabs.xlrelease.domain.tasks.TaskUpdateDirective.UPDATE_TASK_CONFIGURATION;

@Component
public class NotificationTaskUpdater extends DefaultTaskUpdater {

    @Override
    public Class<? extends Task> getTaskClass() {
        return NotificationTask.class;
    }

    @Override
    public Changes update(final Task original, final Task updated, Set<TaskUpdateDirective> updateDirectives) {
        Changes changes = super.update(original, updated, updateDirectives);

        NotificationTask updatedNotificationTask = (NotificationTask) updated;
        NotificationTask originalNotificationTask = (NotificationTask) original;
        if (hasDirectiveToUpdateAllProperties(original, updateDirectives)) {
            updateNotificationConfiguration(updatedNotificationTask, originalNotificationTask);
        } else if (updateDirectives.contains(UPDATE_TASK_CONFIGURATION)) {
            changes.update(original);
            updateNotificationConfiguration(updatedNotificationTask, originalNotificationTask);
        }

        return changes;
    }

    private void updateNotificationConfiguration(final NotificationTask updatedNotificationTask, final NotificationTask originalNotificationTask) {
        originalNotificationTask.setAddresses(updatedNotificationTask.getAddresses());
        originalNotificationTask.setSubject(updatedNotificationTask.getSubject());
        originalNotificationTask.setBody(updatedNotificationTask.getBody());
        originalNotificationTask.setBcc(updatedNotificationTask.getBcc());
        originalNotificationTask.setCc(updatedNotificationTask.getCc());
        originalNotificationTask.setReplyTo(updatedNotificationTask.getReplyTo());
        originalNotificationTask.setFrom(updatedNotificationTask.getFrom());
        originalNotificationTask.setSenderUsername(updatedNotificationTask.getSenderUsername());
        originalNotificationTask.setSenderPassword(PasswordVerificationUtils.replacePasswordIfNeeded(originalNotificationTask.getSenderPassword(), updatedNotificationTask.getSenderPassword()));
        originalNotificationTask.setPriority(updatedNotificationTask.getPriority());
    }

}
