package com.xebialabs.xlrelease.authentication

import com.xebialabs.deployit.security.{PermissionEnforcer, RoleService, UserService}
import com.xebialabs.xlrelease.security.XLReleasePermissions
import org.springframework.security.core.authority.SimpleGrantedAuthority
import org.springframework.security.core.userdetails.{User, UserDetailsService}
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class InternalUserDetailsService(userService: UserService, roleService: RoleService) extends UserDetailsService {
  private def loadAuthorities(username: String) = {
    val user = userService.read(username)
    val isAdmin = user.isAdmin || XLReleasePermissions.isAdmin(user.getUsername)
    val explicitRoles = if (isAdmin) PermissionEnforcer.ROLE_ADMIN :: Nil else Nil
    roleService
      .getRolesFor(username)
      .asScala
      .map(_.getId)
      .toList
      .:::(explicitRoles)
      .map(new SimpleGrantedAuthority(_))
  }

  override def loadUserByUsername(username: String): User = new User(username, "", loadAuthorities(username).asJava)
}
