package com.xebialabs.xlrelease.api.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import com.xebialabs.deployit.security.PermissionLister;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;


/**
 * Returns a global view of the permissions granted to the currently logged in user.
 */
@Path("/security")
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
@Controller
public class SecurityResource {

    private PermissionLister permissionLister;

    private RoleService roleService;

    @Autowired
    public SecurityResource(PermissionLister permissionLister, RoleService roleService) {
        this.permissionLister = permissionLister;
        this.roleService = roleService;
    }

    @GET
    public Map<String, Collection<String>> getGlobalPermissions() {
        return getMyGlobalPermissions();
    }

    private Map<String, Collection<String>> getMyGlobalPermissions() {
        Authentication authentication = Permissions.getAuthentication();
        List<Role> roles = roleService.getRolesFor(authentication);
        HashMap<String, Collection<String>> globalPermissionsAndRoles = convertToStringCollectionHashMap(permissionLister.listGlobalPermissions(roles));
        globalPermissionsAndRoles.put("roles", roles.stream().map(Role::getName).collect(Collectors.toList()));
        return globalPermissionsAndRoles;
    }

    private HashMap<String, Collection<String>> convertToStringCollectionHashMap(final Map<String, List<String>> stringStringMultimap) {
        return new HashMap<>(stringStringMultimap.entrySet().stream()
                .filter(e -> !e.getValue().isEmpty())
                .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }
}
