package com.xebialabs.xlrelease.actors

import akka.actor.ActorLogging
import akka.persistence.{PersistentActor, RuntimePluginConfig}
import com.typesafe.config.Config
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.support.akka.spring.ScalaSpringAwareBean

trait XlrPersistentActor extends PersistentActor with ActorLogging with ScalaSpringAwareBean with RuntimePluginConfig {

  override def journalPluginConfig: Config = {
    XlrConfig.getInstance.akka.akkaPersistenceConfig.getConfig("jdbc-journal")
  }

  override def snapshotPluginConfig: Config = {
    XlrConfig.getInstance.akka.akkaPersistenceConfig.getConfig("jdbc-snapshot-store")
  }

}
