package com.xebialabs.deployit.plumbing.export;

import com.xebialabs.deployit.engine.spi.services.RepositoryFactory;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.ConfigurationItemReaderWriter;
import com.xebialabs.deployit.plumbing.XlrFormatFactory;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.InputStream;

@Component
public class ImportTemplateConfigurationItemReaderWriter extends ConfigurationItemReaderWriter {

    @Autowired
    public ImportTemplateConfigurationItemReaderWriter(RepositoryFactory repositoryFactory,
                                                       XlrFormatFactory formats,
                                                       ConfigurationRepository configurationRepository) {
        super(repositoryFactory, formats, configurationRepository);
    }

    @Override
    protected ConfigurationItemConverter createConverter() {
        return new UnresolvedReferencesConfigurationItemConverter(configurationRepository, null);
    }

    private ConfigurationItemConverter createConverter(ResolutionContext context) {
        return new UnresolvedReferencesConfigurationItemConverter(configurationRepository, context);
    }

    public ConfigurationItem readFrom(ResolutionContext context, final MediaType mediaType, final InputStream entityStream) throws IOException {
        ConfigurationItemConverter converter = createConverter(context);
        CiReader reader = formats.createCiReader(entityStream, mediaType);
        ConfigurationItem result = converter.readCi(reader);
        // Resolve the CI references that were found by the converter while parsing.
        converter.resolveReferences(repository);
        return result;

    }
}
