package com.xebialabs.deployit.core.xml

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor
import com.xebialabs.xltype.serialization.{CiWriter, ConfigurationItemConverter}

import java.util.{Collection => JCollection, Map => JMap}
import scala.jdk.CollectionConverters._

/**
 * Converter, which replaces all the passwords with empty strings.
 */
class WriteWithoutPasswordCiConverter extends ConfigurationItemConverter {

  override def writeStringProperty(value: scala.Any, propertyDescriptor: PropertyDescriptor, writer: CiWriter): Unit = value match {
    case v: String if propertyDescriptor.isPassword =>
      super.writeStringProperty("", propertyDescriptor, writer)
    case _ =>  super.writeStringProperty(value, propertyDescriptor, writer)
  }

  override def writeCollectionOfStringProperty(value: scala.Any, propertyDescriptor: PropertyDescriptor, writer: CiWriter): Unit = {
    value match {
      case v: JCollection[_] if propertyDescriptor.isPassword =>
        super.writeCollectionOfStringProperty(v.asScala.map(_ => "").asJava, propertyDescriptor, writer)
      case v: JCollection[_] =>
        super.writeCollectionOfStringProperty(value, propertyDescriptor, writer)
    }
  }

  override def writeMapStringStringProperty(value: Any, propertyDescriptor: PropertyDescriptor, writer: CiWriter): Unit = {
    val cleanValue = value match {
      case valueMap: JMap[_, _] if propertyDescriptor.isPassword =>
        valueMap.asScala.map( v => (v._1, "")).asJava
      case valueMap => valueMap
    }

    super.writeMapStringStringProperty(cleanValue, propertyDescriptor, writer)
  }

}
