package com.xebialabs.xlrelease.server.jetty

import com.xebialabs.deployit.engine.spi.event.SpringInstantiatedListener
import com.xebialabs.deployit.event.{EventBusHolder, ShutdownEvent}
import com.xebialabs.xlrelease.XLReleaseBootstrapper
import grizzled.slf4j.Logging
import nl.javadude.t2bus.Subscribe
import org.springframework.boot.SpringApplication
import org.springframework.context.ApplicationContext
import org.springframework.context.event.{ContextClosedEvent, EventListener}

class ShutdownEventListener(val applicationContext: ApplicationContext) extends SpringInstantiatedListener with Logging {

  @volatile
  private var isShutdownInitiated = false

  @Subscribe
  def onShutdownEvent(event: ShutdownEvent): Unit = {
    logger.info("Received shutdown event.")
    if (!isShutdownInitiated) {
      isShutdownInitiated = true
      logger.info(s"Shutting down ${XLReleaseBootstrapper.PRODUCT_DIGITALAI} because a shutdown event was received.")
      SpringApplication.exit(applicationContext, () => 0)
    }
  }

  @EventListener
  def onContextClosedEvent(event: ContextClosedEvent): Unit = {
    if (!isShutdownInitiated) {
      isShutdownInitiated = true
      logger.info(s"Shutting down ${XLReleaseBootstrapper.PRODUCT_DIGITALAI} because the process is being terminated.")
      EventBusHolder.publish(new ShutdownEvent())
    }
  }
}
