package com.xebialabs.xlrelease.scheduler.workers

import com.codahale.metrics.annotation.Timed
import com.xebialabs.xlrelease.scheduler.workers.Worker.{ExecuteJob, ProcessJobResult}
import org.springframework.context.annotation.Primary
import org.springframework.stereotype.Component

@Component
@Primary
class CompositeWorker(workers: Array[Worker]) extends Worker {

  @Timed
  lazy val execute: ExecuteJob = workers.sortBy(_.getOrder).map(_.execute).reduceLeft(_ orElse _)

  @Timed
  lazy val processResult: ProcessJobResult = workers.sortBy(_.getOrder).map(_.processResult).reduceLeft(_ orElse _)

}
