package com.xebialabs.deployit.plumbing;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.springframework.stereotype.Component;
import com.google.common.annotations.VisibleForTesting;

import com.xebialabs.xlrelease.views.ArtifactView;
import com.xebialabs.xltype.serialization.json.JsonWriter;

import static com.xebialabs.deployit.plumbing.AbstractConfigurationItemReaderWriter.getClassFromGenericType;
import static com.xebialabs.xlrelease.repository.IdType.DOMAIN;

@Component
@Provider
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_HTML})
public class ReleaseArtifactViewsJsonWriter implements MessageBodyWriter<Collection<ArtifactView>> {
    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            type = getClassFromGenericType(genericType);
        }
        return ArtifactView.class.isAssignableFrom(type);
    }


    @Override
    public long getSize(Collection<ArtifactView> artifactViews, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(Collection<ArtifactView> artifactViews, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(toJson(artifactViews).getBytes(StandardCharsets.UTF_8));
    }

    @VisibleForTesting
    String toJson(Collection<ArtifactView> artifactViews) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter(stringWriter);
        writer.array();

        for (ArtifactView ArtifactView : artifactViews) {
            writeReleaseArtifactView(writer, ArtifactView);
        }

        writer.endArray();
        return stringWriter.toString();
    }

    static void writeReleaseArtifactView(JsonWriter writer, ArtifactView artifactView) {
        writer.object();

        writer.key("id").value(DOMAIN.convertToViewId(artifactView.getId()));
        writer.key("filename").value(artifactView.getFilename());
        writer.key("contentType").value(artifactView.getContentType());

        writer.endObject();
    }
}
