package com.xebialabs.xlrelease.service

import com.xebialabs.deployit.repository.RepositoryAdapter
import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.json.JsonUtils.ReleaseJsonOps
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper.deserialize
import com.xebialabs.xltype.serialization.ConfigurationItemConverter


trait ArchivedReleaseDeserialization {
  def repositoryAdapter: RepositoryAdapter

  def deserializeArchivedRelease(releaseJson: String, repository: RepositoryAdapter, ciConverter: ConfigurationItemConverter): Release = {
    val release = deserialize(releaseJson.withoutUnknownTypes, repository, ciConverter).asInstanceOf[Release]
    release.setArchived(true)
    release
  }
}
