package com.xebialabs.xlrelease.json

import com.fasterxml.jackson.core.JsonGenerator
import com.fasterxml.jackson.databind.{JsonSerializer, SerializerProvider}
import org.springframework.data.domain.Page

class PageSerializer extends JsonSerializer[Page[_]] {

  override def serialize(page: Page[_], jsonGenerator: JsonGenerator, serializers: SerializerProvider): Unit = {
    jsonGenerator.writeStartObject()
    jsonGenerator.writeNumberField("totalElements", page.getTotalElements)
    jsonGenerator.writeNumberField("totalPages", page.getTotalPages)
    jsonGenerator.writeNumberField("size", page.getSize)
    jsonGenerator.writeNumberField("number", page.getNumber)
    jsonGenerator.writeNumberField("numberOfElements", page.getNumberOfElements)
    jsonGenerator.writeObjectField("content", page.getContent)
    jsonGenerator.writeBooleanField("first", page.isFirst)
    jsonGenerator.writeBooleanField("last", page.isLast)
    jsonGenerator.writeEndObject()
  }

}
