package com.xebialabs.xlrelease.upgrade.json

import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.security.XLReleasePermissions
import com.xebialabs.xlrelease.security.XLReleasePermissions.EDIT_TRIGGER
import com.xebialabs.xlrelease.upgrade.Components._
import com.xebialabs.xlrelease.upgrade.ImportUpgrade
import org.codehaus.jettison.json.JSONArray

class XLRelease960EditTriggersPermissionJson extends ImportUpgrade with XLReleaseEditTriggersPermissionJson {

  override def getUpgradeVersion: Version = Version.valueOf(XL_RELEASE_COMPONENT, "9.6.0#3")

  protected def processPermissions(permissionsJSONArray: JSONArray, permissions: Seq[String]): Unit = {
    if (permissions.contains(XLReleasePermissions.EDIT_TEMPLATE_TRIGGERS.getPermissionName)) {
      permissionsJSONArray.remove(XLReleasePermissions.EDIT_TEMPLATE_TRIGGERS.getPermissionName)
      permissionsJSONArray.put(EDIT_TRIGGER.getPermissionName)
    }
  }
}
