package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.xlrelease.repository.PhaseVersion;

@HttpResponseCodeResult(statusCode = 400)
public class RestartPhasesException extends DeployitException {

    private String releaseId;
    private String phaseId;
    private String taskId;
    private PhaseVersion phaseVersion;
    private boolean resumeRelease;

    public RestartPhasesException(final String releaseId, final String phaseId, final String taskId, PhaseVersion phaseVersion, boolean resumeRelease, final String message) {
        super(message);
        this.releaseId = releaseId;
        this.phaseId = phaseId;
        this.taskId = taskId;
        this.phaseVersion = phaseVersion;
        this.resumeRelease = resumeRelease;
    }

    public String getReleaseId() {
        return releaseId;
    }

    public String getPhaseId() {
        return phaseId;
    }

    public String getTaskId() {
        return taskId;
    }

    public PhaseVersion getPhaseVersion() {
        return phaseVersion;
    }

    public boolean isResumeRelease() {
        return resumeRelease;
    }
}
