package com.xebialabs.xlrelease.scheduler

import akka.actor.{ActorSystem, Address}
import akka.cluster.Cluster
import com.xebialabs.xlplatform.cluster.ClusterMode.{Full, HotStandby}
import com.xebialabs.xlrelease.actors.ActorSystemHolder
import com.xebialabs.xlrelease.config.XlrConfig

trait NodeId {
  def actorSystemHolder: ActorSystemHolder

  lazy val nodeId = getNodeId(actorSystemHolder.actorSystem)

  private def getNodeId(actorSystem: ActorSystem): String = XlrConfig.getInstance.clusterMode match {
    case Full | HotStandby => convertAddressToNodeId(Cluster(actorSystem).selfAddress)
    case _ => "default"
  }

  def convertAddressToNodeId(address: Address): String = s"${address.getHost().orElse("?")}:${address.getPort().map(_.toString).orElse("?")}"
}
