package com.xebialabs.xlrelease.principaldata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.springframework.security.core.GrantedAuthority;

import static com.xebialabs.xlrelease.principaldata.UserData.NOT_FOUND;

class PrincipalDataProviderImpl implements PrincipalDataProvider {

    private List<UserDataProvider> userProviders;

    private List<LdapGroupEmailProvider> groupEmailProviders;

    public PrincipalDataProviderImpl() {
        this.userProviders = new ArrayList<>();
        this.groupEmailProviders = new ArrayList<>();
    }

    public void addUserProvider(UserDataProvider provider) {
        this.userProviders.add(provider);
    }

    public void addUserProvider(List<UserDataProvider> providers) {
        this.userProviders.addAll(providers);
    }

    public void addGroupProvider(LdapGroupEmailProvider provider) {
        this.groupEmailProviders.add(provider);
    }

    public void addGroupProvider(List<LdapGroupEmailProvider> providers) {
        this.groupEmailProviders.addAll(providers);
    }

    @Override
    public UserData getUserData(final String username) {
        return this.userProviders.stream()
                .filter(provider -> provider.getUserData(username) != NOT_FOUND)
                .map(provider -> provider.getUserData(username))
                .findFirst()
                .orElse(NOT_FOUND);
    }

    @Override
    public String getGroupEmail(final String groupName) {
        return this.groupEmailProviders.stream()
                .filter(provider -> provider.getGroupEmail(groupName) != null)
                .map(provider -> provider.getGroupEmail(groupName))
                .findFirst()
                .orElse(null);
    }

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities(final String username) {
        return this.userProviders.stream()
                .filter(provider -> !provider.getAuthorities(username).isEmpty())
                .map(provider -> provider.getAuthorities(username))
                .findFirst()
                .orElse(Collections.emptySet());
    }

    @Override
    public void invalidate(String username) {
        //noop
    }
}
