package com.xebialabs.xlrelease.plugin.webhook;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.json.JsonSmartJsonProvider;
import com.jayway.jsonpath.spi.mapper.JsonSmartMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;

public class JsonPathResult {

    //Provider to use for json conversion. JsonSmartJsonProvider throws exception for integer values.
    private static final JsonProvider jacksonJsonProvider = new JacksonJsonProvider();

    //Provider to use for JSON Parsing. JacksonJsonProvider converts json array/list to Java ArrayList instead of JSONArray.
    private static final JsonProvider jsonSmartJsonProvider = new JsonSmartJsonProvider();
    private static final MappingProvider mappingProvider = new JsonSmartMappingProvider();
    private static final Configuration config = Configuration.builder()
            .jsonProvider(jsonSmartJsonProvider)
            .mappingProvider(mappingProvider)
            .options(Option.SUPPRESS_EXCEPTIONS)
            .build();

    private final String json;
    private final String jsonPathExpression;

    public JsonPathResult(String json, String jsonPathExpression) {
        this.json = json;
        this.jsonPathExpression = jsonPathExpression;
    }

    public Object get() {
        return readJson();
    }

    public Object getString() {
        Object object = readJson();
        return object != null ? toJson(object) : null;
    }

    private Object readJson() {
        if (json == null || json.isEmpty()) {
            return null;
        } else {
            return JsonPath.compile(jsonPathExpression).read(json, config);
        }
    }

    private String toJson(Object object) {
        return isString(object) ? (String) object : jacksonJsonProvider.toJson(object);
    }

    private boolean isString(Object object) {
        return object instanceof String;
    }
}

