package com.xebialabs.xlrelease.metrics

import com.codahale.metrics.MetricRegistry
import com.codahale.metrics.jmx.JmxReporter
import com.ryantenney.metrics.spring.config.annotation.{EnableMetrics, MetricsConfigurerAdapter}
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.metrics.MetricsConfiguration._
import org.slf4j.LoggerFactory
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.annotation.{Bean, Configuration}

import java.util.concurrent.TimeUnit

object MetricsConfiguration {
  val METRICS_DOMAIN = "com.xebialabs.xlrelease.metrics"
}

@Configuration
@EnableMetrics(proxyTargetClass = true)
class MetricsConfiguration extends MetricsConfigurerAdapter {

  private lazy val logger = LoggerFactory.getLogger(classOf[MetricsConfiguration])

  override def getMetricRegistry: MetricRegistry = XlrMetricRegistry.metricRegistry

  @Autowired
  var xlrConfig: XlrConfig = _

  @Bean
  def jmxReporter(): JmxReporter = {
    JmxReporter.forRegistry(getMetricRegistry)
      .inDomain(METRICS_DOMAIN)
      .convertRatesTo(TimeUnit.SECONDS)
      .createsObjectNamesWith(XlrObjectNameFactory)
      .build
  }

  override def configureReporters(metricRegistry: MetricRegistry): Unit = {
    if (xlrConfig.metrics.enabled) {
      logger.info("Starting JMX reporter for metrics")
      registerReporter(jmxReporter()).start()
    }
  }


}
