package com.xebialabs.xlrelease.authentication

import org.springframework.security.core.Authentication
import org.springframework.security.core.context.SecurityContextHolder

trait AuthenticationSupport {
  def withAuthentication(authentication: Authentication)(code: => Unit): Unit = {
    val previousAuthentication = SecurityContextHolder.getContext.getAuthentication
    try {
      SecurityContextHolder.getContext.setAuthentication(authentication)
      code
    } finally {
      SecurityContextHolder.getContext.setAuthentication(previousAuthentication)
    }
  }
}
