package com.xebialabs.xlrelease.actors.triggers

import grizzled.slf4j.Logging

import scala.util.Try

trait RepeatOnError extends Logging {

  def repeatOnError[T](call: => T): T = repeatOnErrorTimes(3)(call)

  def repeatOnErrorTimes[T](n: Int)(call:  => T): T = {
    Try(call).recover {
      case ex if n > 1 =>
        val retriesLeft = n - 1
        debug(s"Called failed with exception. Retries left $retriesLeft ...", ex)
        repeatOnErrorTimes(retriesLeft)(call)
      case ex =>
        throw ex
    }.get
  }
}
