package com.xebialabs.deployit.plumbing;

import java.io.Writer;
import javax.ws.rs.core.MediaType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;

import com.xebialabs.deployit.plumbing.xltype.serialization.json.MetadataIncludingCiJsonWriter;
import com.xebialabs.xltype.serialization.CiWriter;
import com.xebialabs.xltype.serialization.rest.FormatFactory;
import com.xebialabs.xltype.serialization.xstream.CiXStreamWriter;

/**
 * This format factory supports a custom writer, which can be used, for instance, to stream the result.
 */
@Component
public class XlrFormatFactory extends FormatFactory {

    private ObjectMapper objectMapper;

    @Autowired
    public XlrFormatFactory(final ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public CiWriter createCiWriter(MediaType mediaType, Writer writer) {
        if (mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            return new MetadataIncludingCiJsonWriter(writer, objectMapper);
        } else if (mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE)) {
            return new CiXStreamWriter(new PrettyPrintWriter(writer));
        } else {
            throw new IllegalArgumentException("Unsupported MediaType: " + mediaType);
        }
    }

}
