package com.xebialabs.xlrelease.server.jetty.http;

import java.util.Locale;

import static org.eclipse.jetty.http.HttpCookie.SAME_SITE_LAX_COMMENT;
import static org.eclipse.jetty.http.HttpCookie.SAME_SITE_STRICT_COMMENT;

public class SameSiteHelper {

    private SameSiteHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static SameSite getSameSiteValue(String value) {
        return SameSite.valueOf(value.toUpperCase(Locale.ENGLISH));
    }

    public static String getSameSiteComment(String sameSite) {
        SameSite sameSiteValue = getSameSiteValue(sameSite);
        return getSameSiteComment(sameSiteValue);
    }

    public static String getSameSiteComment(SameSite sameSite) {
        if (sameSite == SameSite.LAX) {
            return SAME_SITE_LAX_COMMENT;
        } else if (sameSite == SameSite.STRICT) {
            return SAME_SITE_STRICT_COMMENT;
        } else {
            return null;
        }
    }
}
