/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.DependencyBuilder;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.DependencyCreatedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyDeletedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.IdMatchers;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PhaseRepository;
import com.xebialabs.xlrelease.repository.PlanItemRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.DependencyCandidateCollector;
import com.xebialabs.xlrelease.service.IdAndStatus;
import com.xebialabs.xlrelease.service.LockedTaskOperationChecks$;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseTreeBuilder;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import com.xebialabs.xlrelease.views.ReleaseTree;
import com.xebialabs.xlrelease.views.ReleaseTreeItem;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\t-d\u0001B\u0013'\u0001=B\u0001\"\u0012\u0001\u0003\u0006\u0004%\tA\u0012\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u000f\"Aa\n\u0001BC\u0002\u0013\u0005q\n\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003Q\u0011!!\u0006A!b\u0001\n\u0003)\u0006\u0002C-\u0001\u0005\u0003\u0005\u000b\u0011\u0002,\t\u0011i\u0003!Q1A\u0005\u0002mC\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\tA\u0002\u0011)\u0019!C\u0001C\"A\u0001\u000e\u0001B\u0001B\u0003%!\r\u0003\u0005j\u0001\t\u0015\r\u0011\"\u0001k\u0011!q\u0007A!A!\u0002\u0013Y\u0007\u0002C8\u0001\u0005\u000b\u0007I\u0011\u00019\t\u0011Q\u0004!\u0011!Q\u0001\nED\u0001\"\u001e\u0001\u0003\u0006\u0004%\tA\u001e\u0005\tu\u0002\u0011\t\u0011)A\u0005o\"A1\u0010\u0001BC\u0002\u0013\u0005A\u0010C\u0005\u0002\u0002\u0001\u0011\t\u0011)A\u0005{\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001\"CA\u001d\u0001\t\u0007I\u0011AA\u001e\u0011!\t)\u0007\u0001Q\u0001\n\u0005u\u0002bBA4\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u00033\u0003A\u0011AAN\u0011\u001d\t)\u000b\u0001C\u0001\u0003OCq!a0\u0001\t\u0003\t\t\rC\u0004\u0002V\u0002!\t!a6\t\u000f\u0005=\b\u0001\"\u0001\u0002r\"9\u0011\u0011 \u0001\u0005\u0002\u0005m\bb\u0002B\u0002\u0001\u0011\u0005!Q\u0001\u0005\b\u0005\u0017\u0001A\u0011\u0002B\u0007\u0011\u001d\u0011\u0019\u0002\u0001C\u0001\u0005+AqAa\n\u0001\t\u0003\u0011I\u0003C\u0004\u00034\u0001!\tA!\u000e\t\u000f\t\r\u0003\u0001\"\u0003\u0003F!9!\u0011\n\u0001\u0005\u0012\t-\u0003b\u0002B)\u0001\u0011E!1\u000b\u0002\u0012\t\u0016\u0004XM\u001c3f]\u000eL8+\u001a:wS\u000e,'BA\u0014)\u0003\u001d\u0019XM\u001d<jG\u0016T!!\u000b\u0016\u0002\u0013ad'/\u001a7fCN,'BA\u0016-\u0003%AXMY5bY\u0006\u00147OC\u0001.\u0003\r\u0019w.\\\u0002\u0001'\u0015\u0001\u0001G\u000e\u001e>!\t\tD'D\u00013\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0005\u0019\te.\u001f*fMB\u0011q\u0007O\u0007\u0002M%\u0011\u0011H\n\u0002\u0013%\u0016dW-Y:f)J,WMQ;jY\u0012,'\u000f\u0005\u00028w%\u0011AH\n\u0002\u001d\t\u0016\u0004XM\u001c3f]\u000eL8)\u00198eS\u0012\fG/Z\"pY2,7\r^8s!\tq4)D\u0001@\u0015\t\u0001\u0015)A\u0003tY\u001a$$NC\u0001C\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001#@\u0005\u001daunZ4j]\u001e\f\u0011C]3mK\u0006\u001cXMU3q_NLGo\u001c:z+\u00059\u0005C\u0001%L\u001b\u0005I%B\u0001&)\u0003)\u0011X\r]8tSR|'/_\u0005\u0003\u0019&\u0013\u0011CU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u0003I\u0011X\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\u0011\u0002)I,G.Z1tKN+\u0017M]2i'\u0016\u0014h/[2f+\u0005\u0001\u0006CA\u001cR\u0013\t\u0011fE\u0001\u000bSK2,\u0017m]3TK\u0006\u00148\r[*feZL7-Z\u0001\u0016e\u0016dW-Y:f'\u0016\f'o\u00195TKJ4\u0018nY3!\u0003I\u0001H.\u00198Ji\u0016l'+\u001a9pg&$xN]=\u0016\u0003Y\u0003\"\u0001S,\n\u0005aK%A\u0005)mC:LE/Z7SKB|7/\u001b;pef\f1\u0003\u001d7b]&#X-\u001c*fa>\u001c\u0018\u000e^8ss\u0002\nA\u0003Z3qK:$WM\\2z%\u0016\u0004xn]5u_JLX#\u0001/\u0011\u0005!k\u0016B\u00010J\u0005Q!U\r]3oI\u0016t7-\u001f*fa>\u001c\u0018\u000e^8ss\u0006)B-\u001a9f]\u0012,gnY=SKB|7/\u001b;pef\u0004\u0013\u0001C3wK:$()^:\u0016\u0003\t\u0004\"a\u00194\u000e\u0003\u0011T!!\u001a\u0015\u0002\r\u00154XM\u001c;t\u0013\t9GM\u0001\u0005Fm\u0016tGOQ;t\u0003%)g/\u001a8u\u0005V\u001c\b%\u0001\buCN\\'+\u001a9pg&$xN]=\u0016\u0003-\u0004\"\u0001\u00137\n\u00055L%A\u0004+bg.\u0014V\r]8tSR|'/_\u0001\u0010i\u0006\u001c8NU3q_NLGo\u001c:zA\u0005y\u0001\u000f[1tKJ+\u0007o\\:ji>\u0014\u00180F\u0001r!\tA%/\u0003\u0002t\u0013\ny\u0001\u000b[1tKJ+\u0007o\\:ji>\u0014\u00180\u0001\tqQ\u0006\u001cXMU3q_NLGo\u001c:zA\u0005Y1-[%e'\u0016\u0014h/[2f+\u00059\bCA\u001cy\u0013\tIhEA\u0006DS&#7+\u001a:wS\u000e,\u0017\u0001D2j\u0013\u0012\u001cVM\u001d<jG\u0016\u0004\u0013\u0001E1sG\"Lg/\u001b8h'\u0016\u0014h/[2f+\u0005i\bCA\u001c\u007f\u0013\tyhE\u0001\tBe\u000eD\u0017N^5oON+'O^5dK\u0006\t\u0012M]2iSZLgnZ*feZL7-\u001a\u0011\u0002\rqJg.\u001b;?)Q\t9!!\u0003\u0002\f\u00055\u0011qBA\t\u0003'\t)\"a\u0006\u0002\u001aA\u0011q\u0007\u0001\u0005\u0006\u000bN\u0001\ra\u0012\u0005\u0006\u001dN\u0001\r\u0001\u0015\u0005\u0006)N\u0001\rA\u0016\u0005\u00065N\u0001\r\u0001\u0018\u0005\u0006AN\u0001\rA\u0019\u0005\u0006SN\u0001\ra\u001b\u0005\u0006_N\u0001\r!\u001d\u0005\u0006kN\u0001\ra\u001e\u0005\u0006wN\u0001\r! \u0015\u0004'\u0005u\u0001\u0003BA\u0010\u0003ki!!!\t\u000b\t\u0005\r\u0012QE\u0001\u000bC:tw\u000e^1uS>t'\u0002BA\u0014\u0003S\tqAZ1di>\u0014\u0018P\u0003\u0003\u0002,\u00055\u0012!\u00022fC:\u001c(\u0002BA\u0018\u0003c\tqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003g\t1a\u001c:h\u0013\u0011\t9$!\t\u0003\u0013\u0005+Ho\\<je\u0016$\u0017\u0001G1di&4X\rR3qK:$WM\\2z'R\fG/^:fgV\u0011\u0011Q\b\t\u0007\u0003\u007f\ty%!\u0016\u000f\t\u0005\u0005\u00131\n\b\u0005\u0003\u0007\nI%\u0004\u0002\u0002F)\u0019\u0011q\t\u0018\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0014bAA'e\u00059\u0001/Y2lC\u001e,\u0017\u0002BA)\u0003'\u00121aU3r\u0015\r\tiE\r\t\u0005\u0003/\nyF\u0004\u0003\u0002Z\u0005m\u0003cAA\"e%\u0019\u0011Q\f\u001a\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t'a\u0019\u0003\rM#(/\u001b8h\u0015\r\tiFM\u0001\u001aC\u000e$\u0018N^3EKB,g\u000eZ3oGf\u001cF/\u0019;vg\u0016\u001c\b%\u0001\u0004de\u0016\fG/\u001a\u000b\u0007\u0003W\n9(!!\u0011\t\u00055\u00141O\u0007\u0003\u0003_R1!!\u001d)\u0003\u0019!w.\\1j]&!\u0011QOA8\u0005)!U\r]3oI\u0016t7-\u001f\u0005\b\u0003s2\u0002\u0019AA>\u0003\u00119\u0017\r^3\u0011\t\u00055\u0014QP\u0005\u0005\u0003\u007f\nyG\u0001\u0005HCR,G+Y:l\u0011\u001d\t\u0019I\u0006a\u0001\u0003+\n!\u0003^1sO\u0016$\u0018\nZ(s-\u0006\u0014\u0018.\u00192mK\"\u001aa#a\"\u0011\t\u0005%\u0015QS\u0007\u0003\u0003\u0017SA!a\t\u0002\u000e*!\u0011qRAI\u0003\u001diW\r\u001e:jGNT1!a%-\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BAL\u0003\u0017\u0013Q\u0001V5nK\u0012\fA\"\u001e9eCR,G+\u0019:hKR$b!a\u001b\u0002\u001e\u0006\u0005\u0006bBAP/\u0001\u0007\u0011QK\u0001\rI\u0016\u0004XM\u001c3f]\u000eL\u0018\n\u001a\u0005\b\u0003\u0007;\u0002\u0019AA+Q\r9\u0012qQ\u0001\u0007I\u0016dW\r^3\u0015\r\u0005%\u0016qVA]!\r\t\u00141V\u0005\u0004\u0003[\u0013$\u0001B+oSRDq!!-\u0019\u0001\u0004\t\u0019,A\u0004sK2,\u0017m]3\u0011\t\u00055\u0014QW\u0005\u0005\u0003o\u000byGA\u0004SK2,\u0017m]3\t\u000f\u0005m\u0006\u00041\u0001\u0002V\u0005\u0011\u0011\u000e\u001a\u0015\u00041\u0005\u001d\u0015!F4fi\u000e{W\u000e\u001d7fi\u0006\u0014G.Z$bi\u0016LEm\u001d\u000b\u0005\u0003{\t\u0019\rC\u0004\u0002Ff\u0001\r!a2\u0002\u000fQ\f'oZ3ugB1\u0011qKAe\u0003\u001bLA!a3\u0002d\t\u00191+\u001a;\u0011\t\u00055\u0014qZ\u0005\u0005\u0003#\fyG\u0001\u0005QY\u0006t\u0017\n^3nQ\rI\u0012qQ\u0001\u001aM&tG-Q2uSZ,\u0017J\\2p[&twmR1uK&#7\u000f\u0006\u0003\u0002Z\u0006%\bCBAn\u0003K\f)&\u0004\u0002\u0002^*!\u0011q\\Aq\u0003\u0011)H/\u001b7\u000b\u0005\u0005\r\u0018\u0001\u00026bm\u0006LA!a:\u0002^\n!A*[:u\u0011\u001d\tYO\u0007a\u0001\u0003+\n\u0011B]3mK\u0006\u001cX-\u00133)\u0007i\t9)\u0001\u0010gS:$\u0017i\u0019;jm\u0016LenY8nS:<G)\u001a9f]\u0012,gnY5fgR!\u00111_A{!\u0019\ty$a\u0014\u0002l!9\u0011q_\u000eA\u0002\u0005U\u0013\u0001\u00039be\u0016tG/\u00133\u0002%\u001d,GOR1jY\u0006\u0014G.Z$bi\u0016LEm\u001d\u000b\u0005\u0003{\ti\u0010C\u0004\u0002\u0000r\u0001\r!a2\u0002\u001d\u0005\u0014wN\u001d;fIR\u000b'oZ3ug\"\u001aA$a\"\u00027\u0019Lg\u000eZ!di&4XmT;uO>Lgn\u001a+be\u001e,G/\u00133t)\u0011\tINa\u0002\t\u000f\u0005-X\u00041\u0001\u0002V!\u001aQ$a\"\u00023\u0019Lg\u000eZ!di&4XmT;uO>Lgn\u001a+be\u001e,Go\u001d\u000b\u0005\u0005\u001f\u0011\t\u0002\u0005\u0004\u0002@\u0005=\u0013Q\u001a\u0005\b\u0003Wt\u0002\u0019AA+\u000399W\r\u001e*fY\u0016\f7/\u001a+sK\u0016$BAa\u0006\u0003$A!!\u0011\u0004B\u0010\u001b\t\u0011YBC\u0002\u0003\u001e!\nQA^5foNLAA!\t\u0003\u001c\tY!+\u001a7fCN,GK]3f\u0011\u001d\tYo\ba\u0001\u0003+B3aHAD\u0003M\t'o\u00195jm\u0016$U\r]3oI\u0016t7-[3t)\u0019\tIKa\u000b\u0003.!9\u00111\u001e\u0011A\u0002\u0005U\u0003b\u0002B\u0018A\u0001\u0007\u0011QH\u0001\u000eI\u0016\u0004XM\u001c3f]\u000eL\u0018\nZ:)\u0007\u0001\n9)\u0001\u0010gS:$G)\u001a9f]\u0012,gnY=UCJ<W\r\u001e\"z)\u0006\u0014x-\u001a;JIR!!q\u0007B\u001f!\r9$\u0011H\u0005\u0004\u0005w1#aC%e\u0003:$7\u000b^1ukNDqAa\u0010\"\u0001\u0004\t)&\u0001\u0005uCJ<W\r^%eQ\r\t\u0013qQ\u0001\nO\u0016$8\u000b^1ukN$B!!\u0016\u0003H!9!q\b\u0012A\u0002\u0005U\u0013!\b4j]\u0012Le\u000e\u0015:pOJ,7o]%oG>l\u0017N\\4HCR,\u0017\nZ:\u0015\t\u0005u\"Q\n\u0005\b\u0005\u001f\u001a\u0003\u0019AA\u001f\u0003%!\u0018M]4fi&#7/\u0001\u0006jgR+W\u000e\u001d7bi\u0016$BA!\u0016\u0003\\A\u0019\u0011Ga\u0016\n\u0007\te#GA\u0004C_>dW-\u00198\t\u000f\u0005}E\u00051\u0001\u0002V!\u001a\u0001Aa\u0018\u0011\t\t\u0005$qM\u0007\u0003\u0005GRAA!\u001a\u0002.\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\t\t%$1\r\u0002\b'\u0016\u0014h/[2f\u0001")
public class DependencyService
implements ReleaseTreeBuilder,
DependencyCandidateCollector,
Logging {
    private final ReleaseRepository releaseRepository;
    private final ReleaseSearchService releaseSearchService;
    private final PlanItemRepository planItemRepository;
    private final DependencyRepository dependencyRepository;
    private final EventBus eventBus;
    private final TaskRepository taskRepository;
    private final PhaseRepository phaseRepository;
    private final CiIdService ciIdService;
    private final ArchivingService archivingService;
    private final scala.collection.immutable.Seq<String> activeDependencyStatuses;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public java.util.List<Dependency> findByReleaseId(String releaseId) {
        return DependencyCandidateCollector.findByReleaseId$(this, releaseId);
    }

    @Override
    @Timed
    public java.util.List<Release> findAllDependencyCandidates(String gateId) {
        return DependencyCandidateCollector.findAllDependencyCandidates$(this, gateId);
    }

    @Override
    @Timed
    public Release getDependencyCandidate(String gateId, String targetReleaseId) {
        return DependencyCandidateCollector.getDependencyCandidate$(this, gateId, targetReleaseId);
    }

    @Override
    public scala.collection.immutable.Seq<String> getReferencedCis(String gateReleaseId) {
        return DependencyCandidateCollector.getReferencedCis$(this, gateReleaseId);
    }

    @Override
    public boolean isReferencable(PlanItem planItem, scala.collection.immutable.Seq<String> referencedIds) {
        return DependencyCandidateCollector.isReferencable$(this, planItem, referencedIds);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, Map<String, ReleaseTreeItem> dependentReleases, PlanItem item) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, item);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, Map<String, ReleaseTreeItem> dependentReleases, TaskGroup taskGroup) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, taskGroup);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, Map<String, ReleaseTreeItem> dependentReleases, GateTask gateTask) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, gateTask);
    }

    @Override
    public Object loadDependentRelease(Dependency dependency, String releaseId, Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.loadDependentRelease$(this, dependency, releaseId, dependentReleases);
    }

    @Override
    public PartialFunction<Task, ReleaseTreeItem> taskMatcher(String releaseId, Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.taskMatcher$(this, releaseId, dependentReleases);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DependencyService dependencyService = this;
        synchronized (dependencyService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseSearchService releaseSearchService() {
        return this.releaseSearchService;
    }

    public PlanItemRepository planItemRepository() {
        return this.planItemRepository;
    }

    @Override
    public DependencyRepository dependencyRepository() {
        return this.dependencyRepository;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    public PhaseRepository phaseRepository() {
        return this.phaseRepository;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public scala.collection.immutable.Seq<String> activeDependencyStatuses() {
        return this.activeDependencyStatuses;
    }

    @Timed
    public Dependency create(GateTask gate, String targetIdOrVariable) {
        Checks.checkArgument((boolean)gate.isUpdatable(), (String)"You can't add a dependency to a finished gate", (Object[])new Object[0]);
        LockedTaskOperationChecks$.MODULE$.checkCreateDependency((Task)gate);
        Dependency dependency = DependencyBuilder.newDependency().withId(this.ciIdService().getUniqueId(Type.valueOf(Dependency.class), gate.getId())).build();
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
        } else {
            Object target = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTarget(target);
        }
        gate.addDependency(dependency);
        dependency.setGateTask(gate);
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().create(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyCreatedEvent(dependency));
        return dependency;
    }

    @Timed
    public Dependency updateTarget(String dependencyId, String targetIdOrVariable) {
        String gateId = Ids.getParentId((String)dependencyId);
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        Checks.checkArgument((boolean)gate.isUpdatable(), (String)"You can't edit a dependency on a finished gate", (Object[])new Object[0]);
        LockedTaskOperationChecks$.MODULE$.checkUpdateDependency((Task)gate);
        Dependency dependency = gate.getDependencies().stream().filter(d -> {
            String string = dependencyId;
            String string2 = d.getId();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).findFirst().orElseThrow(() -> new NotFoundException(String.format("Dependency with Id '%s' not found.", dependencyId), new Object[0]));
        Dependency original = CiCloneHelper.cloneCi(dependency);
        Checks.checkArgument((!dependency.isDone() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be updated", (Object[])new Object[0]);
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(null);
        } else {
            Object newTarget = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(newTarget);
        }
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().update(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyUpdatedEvent(original, dependency));
        return dependency;
    }

    @Timed
    public void delete(Release release, String id) {
        Option maybeDependency = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllGates()).asScala().flatMap((Function1 & Serializable)x$2 -> CollectionConverters$.MODULE$.ListHasAsScala(x$2.getDependencies()).asScala())).find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DependencyService.$anonfun$delete$2(id, x$3)));
        Dependency dependency = (Dependency)maybeDependency.getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Repository entity [" + id + "] not found", new Object[0]);
        });
        GateTask gate = dependency.getGateTask();
        LockedTaskOperationChecks$.MODULE$.checkDeleteDependency((Task)gate);
        Checks.checkArgument((!dependency.isDone() || gate.isPlanned() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be deleted", (Object[])new Object[0]);
        this.dependencyRepository().delete(dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyDeletedEvent(dependency));
    }

    @Timed
    public scala.collection.immutable.Seq<String> getCompletableGateIds(Set<PlanItem> targets) {
        scala.collection.immutable.Seq doneTargetIds = ((IterableOnceOps)((IterableOps)targets.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isDone()))).map((Function1 & Serializable)x$5 -> x$5.getId())).toSeq();
        this.logger().trace((Function0 & Serializable)() -> "getCompletableGateIds doneTargetIds: " + doneTargetIds.mkString(", "));
        return (scala.collection.immutable.Seq)((IterableOps)((IterableOps)this.findInProgressIncomingGateIds((scala.collection.immutable.Seq<String>)doneTargetIds).map((Function1 & Serializable)id -> {
            GateTask item = (GateTask)this.taskRepository().findById((String)id);
            this.logger().trace((Function0 & Serializable)() -> "getCompletableGateIds item " + item.getId() + ": hasConditions = " + item.hasConditions() + ", hasDependencies = " + item.hasDependencies() + ", isOpen = " + item.isOpen() + ", status = " + item.getStatus());
            return item;
        })).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isCompletable()))).map((Function1 & Serializable)x$7 -> x$7.getId());
    }

    @Timed
    public java.util.List<String> findActiveIncomingGateIds(String releaseId) {
        Seq seq;
        if (this.releaseRepository().exists(releaseId)) {
            seq = (Seq)((SeqOps)this.findActiveIncomingDependencies(releaseId).map((Function1 & Serializable)dep -> Ids.getParentId((String)dep.getId()))).distinct();
        } else {
            this.logger().debug((Function0 & Serializable)() -> "Release " + releaseId + " not found. It is either archived, or does not exist. Returning no dependencies");
            seq = (Seq)package$.MODULE$.Seq().empty();
        }
        return CollectionConverters$.MODULE$.SeqHasAsJava(seq).asJava();
    }

    public scala.collection.immutable.Seq<Dependency> findActiveIncomingDependencies(String parentId) {
        return this.dependencyRepository().findAllIncomingDependencies((scala.collection.immutable.Seq<String>)new .colon.colon((Object)parentId, (List)Nil$.MODULE$), this.activeDependencyStatuses(), true, false);
    }

    @Timed
    public scala.collection.immutable.Seq<String> getFailableGateIds(Set<PlanItem> abortedTargets) {
        return this.findInProgressIncomingGateIds((scala.collection.immutable.Seq<String>)((IterableOnceOps)abortedTargets.map((Function1 & Serializable)x$8 -> x$8.getId())).toSeq());
    }

    @Timed
    public java.util.List<String> findActiveOutgoingTargetIds(String releaseId) {
        java.util.List targetIds = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.findActiveOutgoingTargets(releaseId).map((Function1 & Serializable)x$9 -> x$9.getId())).asJava();
        return targetIds;
    }

    private scala.collection.immutable.Seq<PlanItem> findActiveOutgoingTargets(String releaseId) {
        java.util.List<Dependency> dependencies = this.findByReleaseId(releaseId);
        scala.collection.immutable.Seq targets = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(dependencies).asScala().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Dependency, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = x1;
                if (A12 != null && (A1 = A12).hasResolvedTarget() && !A1.isDone()) {
                    return (B1)A1.getTarget();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Dependency x1) {
                Dependency dependency;
                Dependency dependency2 = x1;
                return dependency2 != null && (dependency = dependency2).hasResolvedTarget() && !dependency.isDone();
            }
        })).toSeq();
        return targets;
    }

    @Timed
    public ReleaseTree getReleaseTree(String releaseId) {
        if (this.archivingService().exists(releaseId)) {
            return new ReleaseTree();
        }
        Map dependentReleases = (Map)Map$.MODULE$.empty();
        Release release = this.releaseRepository().findById(releaseId);
        this.toTreeItem(releaseId, (Map<String, ReleaseTreeItem>)dependentReleases, (PlanItem)release);
        ReleaseTree tree = new ReleaseTree();
        tree.releaseId_$eq(releaseId);
        tree.dependentReleases_$eq(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)dependentReleases.values().toList()).asJava());
        return tree;
    }

    @Timed
    public void archiveDependencies(String releaseId, scala.collection.immutable.Seq<String> dependencyIds) {
        Release referencingRelease = this.releaseRepository().findById(releaseId);
        Buffer dependenciesToArchive = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(referencingRelease.getAllGates()).asScala().flatMap((Function1 & Serializable)x$10 -> CollectionConverters$.MODULE$.ListHasAsScala(x$10.getDependencies()).asScala())).filter((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)dependencyIds.contains((Object)d.getId())));
        dependenciesToArchive.foreach((Function1 & Serializable)x$11 -> {
            x$11.archive();
            return BoxedUnit.UNIT;
        });
        this.dependencyRepository().archive(referencingRelease, (scala.collection.immutable.Seq<Dependency>)dependenciesToArchive.toSeq());
    }

    @Timed
    public IdAndStatus findDependencyTargetByTargetId(String targetId) {
        return new IdAndStatus(targetId, this.getStatus(targetId));
    }

    private String getStatus(String targetId) {
        Option option;
        Option option2;
        Option option3;
        String string = targetId;
        if (string != null && !(option3 = IdMatchers.ReleaseId$.MODULE$.unapply(string)).isEmpty()) {
            return (String)Try$.MODULE$.apply((Function0 & Serializable)() -> this.releaseRepository().getStatus(targetId).toString()).recover((PartialFunction)new Serializable(this, targetId){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ DependencyService $outer;
                private final String targetId$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        return (B1)this.$outer.archivingService().getRelease(this.targetId$1).getStatus().toString();
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    return throwable != null;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.targetId$1 = targetId$1;
                }
            }).getOrElse((Function0 & Serializable)() -> {
                throw new LogFriendlyNotFoundException("Release [" + targetId + "] not found", new Object[0]);
            });
        }
        if (string != null && !(option2 = IdMatchers.PhaseId$.MODULE$.unapply(string)).isEmpty()) {
            return (String)Try$.MODULE$.apply((Function0 & Serializable)() -> this.phaseRepository().getStatus(targetId).toString()).recover((PartialFunction)new Serializable(this, targetId){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ DependencyService $outer;
                private final String targetId$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    if (A1 != null) {
                        return (B1)this.$outer.archivingService().getPhase(this.targetId$1).getStatus().toString();
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(Throwable x2) {
                    Throwable throwable = x2;
                    return throwable != null;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.targetId$1 = targetId$1;
                }
            }).getOrElse((Function0 & Serializable)() -> {
                throw new LogFriendlyNotFoundException("Phase [" + targetId + "] not found", new Object[0]);
            });
        }
        if (string != null && !(option = IdMatchers.TaskId$.MODULE$.unapply(string)).isEmpty()) {
            return (String)Try$.MODULE$.apply((Function0 & Serializable)() -> this.taskRepository().getStatus(targetId).toString()).recover((PartialFunction)new Serializable(this, targetId){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ DependencyService $outer;
                private final String targetId$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    A1 A1 = x3;
                    if (A1 != null) {
                        return (B1)this.$outer.archivingService().getTask(this.targetId$1).getStatus().toString();
                    }
                    return (B1)function1.apply(x3);
                }

                public final boolean isDefinedAt(Throwable x3) {
                    Throwable throwable = x3;
                    return throwable != null;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.targetId$1 = targetId$1;
                }
            }).getOrElse((Function0 & Serializable)() -> {
                throw new LogFriendlyNotFoundException("Task [" + targetId + "] not found", new Object[0]);
            });
        }
        throw new NotFoundException("Target is not plan item, targetId= " + targetId, new Object[0]);
    }

    public scala.collection.immutable.Seq<String> findInProgressIncomingGateIds(scala.collection.immutable.Seq<String> targetIds) {
        return (scala.collection.immutable.Seq)((SeqOps)this.dependencyRepository().findAllIncomingDependencies(targetIds, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)TaskStatus.IN_PROGRESS.name(), (List)Nil$.MODULE$), false, this.dependencyRepository().findAllIncomingDependencies$default$4()).map((Function1 & Serializable)dep -> Ids.getParentId((String)dep.getId()))).distinct();
    }

    public boolean isTemplate(String dependencyId) {
        return this.releaseRepository().isTemplate(Ids.releaseIdFrom((String)dependencyId));
    }

    public static final /* synthetic */ boolean $anonfun$delete$2(String id$1, Dependency x$3) {
        String string = x$3.getId();
        String string2 = Ids.normalizeId((String)id$1);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public DependencyService(ReleaseRepository releaseRepository, ReleaseSearchService releaseSearchService, PlanItemRepository planItemRepository, DependencyRepository dependencyRepository, EventBus eventBus, TaskRepository taskRepository, PhaseRepository phaseRepository, CiIdService ciIdService, ArchivingService archivingService) {
        this.releaseRepository = releaseRepository;
        this.releaseSearchService = releaseSearchService;
        this.planItemRepository = planItemRepository;
        this.dependencyRepository = dependencyRepository;
        this.eventBus = eventBus;
        this.taskRepository = taskRepository;
        this.phaseRepository = phaseRepository;
        this.ciIdService = ciIdService;
        this.archivingService = archivingService;
        ReleaseTreeBuilder.$init$(this);
        DependencyCandidateCollector.$init$(this);
        Logging.$init$((Logging)this);
        this.activeDependencyStatuses = (scala.collection.immutable.Seq)((IterableOps)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])TaskStatus.ACTIVE_STATUSES)).$colon$plus((Object)TaskStatus.PLANNED)).map((Function1 & Serializable)x$1 -> x$1.name());
    }
}

