/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.logs;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.NoSerializationVerificationNeeded;
import akka.actor.ReceiveTimeout$;
import akka.actor.SupervisorStrategy;
import akka.annotation.InternalApi;
import akka.event.LoggingReceive$;
import akka.event.slf4j.SLF4JLogging;
import com.xebialabs.xlrelease.scheduler.logs.ExecutionLogWatchActor$;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionEntry;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionLogService;
import com.xebialabs.xlrelease.service.SseService;
import com.xebialabs.xlrelease.storage.domain.JobEntryRef;
import com.xebialabs.xlrelease.storage.domain.StorageEntryRef;
import com.xebialabs.xlrelease.storage.service.StorageService;
import com.xebialabs.xlrelease.support.akka.spring.SpringActor;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.time.Instant;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Using;
import scala.util.Using$;

@SpringActor
@ScalaSignature(bytes="\u0006\u0005\u0011}caBA\u001b\u0003o\u0001\u0011Q\n\u0005\u000b\u0003w\u0002!\u0011!Q\u0001\n\u0005u\u0004BCAC\u0001\t\u0005\t\u0015!\u0003\u0002\b\"Q\u0011q\u0013\u0001\u0003\u0002\u0003\u0006I!!'\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002&\"Y\u0011q\u0016\u0001A\u0002\u0003\u0007I\u0011AAY\u0011-\tI\r\u0001a\u0001\u0002\u0004%\t!a3\t\u0017\u0005]\u0007\u00011A\u0001B\u0003&\u00111\u0017\u0005\f\u00033\u0004\u0001\u0019!a\u0001\n\u0003\t\t\fC\u0006\u0002\\\u0002\u0001\r\u00111A\u0005\u0002\u0005u\u0007bCAq\u0001\u0001\u0007\t\u0011)Q\u0005\u0003gC\u0011\"a9\u0001\u0001\u0004%\t!!:\t\u0013\u0005]\b\u00011A\u0005\u0002\u0005e\b\u0002CA\u007f\u0001\u0001\u0006K!a:\t\u000f\u0005}\b\u0001\"\u0011\u0003\u0002!9!1\u0002\u0001\u0005B\t5\u0001b\u0002B\b\u0001\u0011%!\u0011\u0003\u0005\b\t\u007f\u0001A\u0011\u0002C!\u0011\u001d!)\u0005\u0001C\u0005\t\u000f:\u0001Ba\f\u00028!\u0005!\u0011\u0007\u0004\t\u0003k\t9\u0004#\u0001\u00034!9\u00111\u0015\u000b\u0005\u0002\tU\u0002\"\u0003B\u001c)\t\u0007IQAAY\u0011!\u0011I\u0004\u0006Q\u0001\u000e\u0005M\u0006\"\u0003B\u001e)\t\u0007IQAAY\u0011!\u0011i\u0004\u0006Q\u0001\u000e\u0005M\u0006\"\u0003B )\t\u0007IQAAY\u0011!\u0011\t\u0005\u0006Q\u0001\u000e\u0005M\u0006\"\u0003B\")\t\u0007IQAAY\u0011!\u0011)\u0005\u0006Q\u0001\u000e\u0005Mf!\u0003B$)A\u0005\u0019\u0013\u0005B%\u0011\u001d\tyK\bD\u0001\u0003c3aa!\u0010\u0015\u0001\u000e}\u0002BCAmA\tU\r\u0011\"\u0001\u00022\"Q\u0011\u0011\u001d\u0011\u0003\u0012\u0003\u0006I!a-\t\u0015\u0005=\u0006E!f\u0001\n\u0003\t\t\f\u0003\u0006\u0002X\u0002\u0012\t\u0012)A\u0005\u0003gC!ba\u0012!\u0005+\u0007I\u0011AAY\u0011)\u0019I\u0005\tB\tB\u0003%\u00111\u0017\u0005\b\u0003G\u0003C\u0011AB&\u0011%\u0011\u0019\bIA\u0001\n\u0003\u0019)\u0006C\u0005\u0003z\u0001\n\n\u0011\"\u0001\u0003|!I1\u0011\u0002\u0011\u0012\u0002\u0013\u0005!1\u0010\u0005\n\u0007;\u0002\u0013\u0013!C\u0001\u0005wB\u0011B!%!\u0003\u0003%\tEa%\t\u0013\t}\u0005%!A\u0005\u0002\t\u0005\u0006\"\u0003BUA\u0005\u0005I\u0011AB0\u0011%\u0011)\fIA\u0001\n\u0003\u00129\fC\u0005\u0003F\u0002\n\t\u0011\"\u0001\u0004d!I!\u0011\u001b\u0011\u0002\u0002\u0013\u00053q\r\u0005\n\u0005/\u0004\u0013\u0011!C!\u00053D\u0011Ba7!\u0003\u0003%\tE!8\t\u0013\t}\u0007%!A\u0005B\r-t!CBO)\u0005\u0005\t\u0012ABP\r%\u0019i\u0004FA\u0001\u0012\u0003\u0019\t\u000bC\u0004\u0002$Z\"\ta!/\t\u0013\tmg'!A\u0005F\tu\u0007\"CB^m\u0005\u0005I\u0011QB_\u0011%\u0019)MNA\u0001\n\u0003\u001b9\rC\u0005\u0004VZ\n\t\u0011\"\u0003\u0004X\u001a11q\u000e\u000bA\u0007cB!\"a,=\u0005+\u0007I\u0011AAY\u0011)\t9\u000e\u0010B\tB\u0003%\u00111\u0017\u0005\u000b\u0007\u000fb$Q3A\u0005\u0002\rM\u0004BCB%y\tE\t\u0015!\u0003\u0004v!9\u00111\u0015\u001f\u0005\u0002\rm\u0004\"\u0003B:y\u0005\u0005I\u0011ABB\u0011%\u0011I\bPI\u0001\n\u0003\u0011Y\bC\u0005\u0004\nq\n\n\u0011\"\u0001\u0004\n\"I!\u0011\u0013\u001f\u0002\u0002\u0013\u0005#1\u0013\u0005\n\u0005?c\u0014\u0011!C\u0001\u0005CC\u0011B!+=\u0003\u0003%\ta!$\t\u0013\tUF(!A\u0005B\t]\u0006\"\u0003Bcy\u0005\u0005I\u0011ABI\u0011%\u0011\t\u000ePA\u0001\n\u0003\u001a)\nC\u0005\u0003Xr\n\t\u0011\"\u0011\u0003Z\"I!1\u001c\u001f\u0002\u0002\u0013\u0005#Q\u001c\u0005\n\u0005?d\u0014\u0011!C!\u00073;\u0011ba8\u0015\u0003\u0003E\ta!9\u0007\u0013\r=D#!A\t\u0002\r\r\bbBAR\u001f\u0012\u000511\u001e\u0005\n\u00057|\u0015\u0011!C#\u0005;D\u0011ba/P\u0003\u0003%\ti!<\t\u0013\r\u0015w*!A\u0005\u0002\u000eM\b\"CBk\u001f\u0006\u0005I\u0011BBl\r\u0019\u0011i\u0005\u0006!\u0003P!Q\u0011qV+\u0003\u0016\u0004%\t!!-\t\u0015\u0005]WK!E!\u0002\u0013\t\u0019\fC\u0004\u0002$V#\tA!\u001c\t\u0013\tMT+!A\u0005\u0002\tU\u0004\"\u0003B=+F\u0005I\u0011\u0001B>\u0011%\u0011\t*VA\u0001\n\u0003\u0012\u0019\nC\u0005\u0003 V\u000b\t\u0011\"\u0001\u0003\"\"I!\u0011V+\u0002\u0002\u0013\u0005!1\u0016\u0005\n\u0005k+\u0016\u0011!C!\u0005oC\u0011B!2V\u0003\u0003%\tAa2\t\u0013\tEW+!A\u0005B\tM\u0007\"\u0003Bl+\u0006\u0005I\u0011\tBm\u0011%\u0011Y.VA\u0001\n\u0003\u0012i\u000eC\u0005\u0003`V\u000b\t\u0011\"\u0011\u0003b\u001eI1q \u000b\u0002\u0002#\u0005A\u0011\u0001\u0004\n\u0005\u001b\"\u0012\u0011!E\u0001\t\u0007Aq!a)f\t\u0003!Y\u0001C\u0005\u0003\\\u0016\f\t\u0011\"\u0012\u0003^\"I11X3\u0002\u0002\u0013\u0005EQ\u0002\u0005\n\u0007\u000b,\u0017\u0011!CA\t#A\u0011b!6f\u0003\u0003%Iaa6\u0007\r\r}A\u0003QB\u0011\u0011)\tyk\u001bBK\u0002\u0013\u0005\u0011\u0011\u0017\u0005\u000b\u0003/\\'\u0011#Q\u0001\n\u0005M\u0006bBARW\u0012\u000511\u0005\u0005\n\u0005gZ\u0017\u0011!C\u0001\u0007SA\u0011B!\u001fl#\u0003%\tAa\u001f\t\u0013\tE5.!A\u0005B\tM\u0005\"\u0003BPW\u0006\u0005I\u0011\u0001BQ\u0011%\u0011Ik[A\u0001\n\u0003\u0019i\u0003C\u0005\u00036.\f\t\u0011\"\u0011\u00038\"I!QY6\u0002\u0002\u0013\u00051\u0011\u0007\u0005\n\u0005#\\\u0017\u0011!C!\u0007kA\u0011Ba6l\u0003\u0003%\tE!7\t\u0013\tm7.!A\u0005B\tu\u0007\"\u0003BpW\u0006\u0005I\u0011IB\u001d\u000f%!)\u0002FA\u0001\u0012\u0003!9BB\u0005\u0004 Q\t\t\u0011#\u0001\u0005\u001a!9\u00111U>\u0005\u0002\u0011u\u0001\"\u0003Bnw\u0006\u0005IQ\tBo\u0011%\u0019Yl_A\u0001\n\u0003#y\u0002C\u0005\u0004Fn\f\t\u0011\"!\u0005$!I1Q[>\u0002\u0002\u0013%1q\u001b\u0004\u0007\u0005K$\u0002Ia:\t\u0017\u0005=\u00161\u0001BK\u0002\u0013\u0005\u0011\u0011\u0017\u0005\f\u0003/\f\u0019A!E!\u0002\u0013\t\u0019\fC\u0006\u0003j\u0006\r!Q3A\u0005\u0002\t-\bb\u0003B}\u0003\u0007\u0011\t\u0012)A\u0005\u0005[D\u0001\"a)\u0002\u0004\u0011\u0005!1 \u0005\u000b\u0005g\n\u0019!!A\u0005\u0002\r\r\u0001B\u0003B=\u0003\u0007\t\n\u0011\"\u0001\u0003|!Q1\u0011BA\u0002#\u0003%\taa\u0003\t\u0015\tE\u00151AA\u0001\n\u0003\u0012\u0019\n\u0003\u0006\u0003 \u0006\r\u0011\u0011!C\u0001\u0005CC!B!+\u0002\u0004\u0005\u0005I\u0011AB\b\u0011)\u0011),a\u0001\u0002\u0002\u0013\u0005#q\u0017\u0005\u000b\u0005\u000b\f\u0019!!A\u0005\u0002\rM\u0001B\u0003Bi\u0003\u0007\t\t\u0011\"\u0011\u0004\u0018!Q!q[A\u0002\u0003\u0003%\tE!7\t\u0015\tm\u00171AA\u0001\n\u0003\u0012i\u000e\u0003\u0006\u0003`\u0006\r\u0011\u0011!C!\u000779\u0011\u0002b\n\u0015\u0003\u0003E\t\u0001\"\u000b\u0007\u0013\t\u0015H#!A\t\u0002\u0011-\u0002\u0002CAR\u0003S!\t\u0001b\f\t\u0015\tm\u0017\u0011FA\u0001\n\u000b\u0012i\u000e\u0003\u0006\u0004<\u0006%\u0012\u0011!CA\tcA!b!2\u0002*\u0005\u0005I\u0011\u0011C\u001c\u0011)\u0019).!\u000b\u0002\u0002\u0013%1q\u001b\u0002\u0017\u000bb,7-\u001e;j_:dunZ,bi\u000eD\u0017i\u0019;pe*!\u0011\u0011HA\u001e\u0003\u0011awnZ:\u000b\t\u0005u\u0012qH\u0001\ng\u000eDW\rZ;mKJTA!!\u0011\u0002D\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0005\u0003\u000b\n9%A\u0005yK\nL\u0017\r\\1cg*\u0011\u0011\u0011J\u0001\u0004G>l7\u0001A\n\b\u0001\u0005=\u00131LA6!\u0011\t\t&a\u0016\u000e\u0005\u0005M#BAA+\u0003\u0015\u00198-\u00197b\u0013\u0011\tI&a\u0015\u0003\r\u0005s\u0017PU3g!\u0011\ti&a\u001a\u000e\u0005\u0005}#\u0002BA1\u0003G\nQ!Y2u_JT!!!\u001a\u0002\t\u0005\\7.Y\u0005\u0005\u0003S\nyFA\u0003BGR|'\u000f\u0005\u0003\u0002n\u0005]TBAA8\u0015\u0011\t\t(a\u001d\u0002\u000bMdg\r\u000e6\u000b\t\u0005U\u00141M\u0001\u0006KZ,g\u000e^\u0005\u0005\u0003s\nyG\u0001\u0007T\u0019\u001a#$\nT8hO&tw-A\fuCN\\W\t_3dkRLwN\u001c'pON+'O^5dKB!\u0011qPAA\u001b\t\t9$\u0003\u0003\u0002\u0004\u0006]\"a\u0006+bg.,\u00050Z2vi&|g\u000eT8h'\u0016\u0014h/[2f\u00039\u0019Ho\u001c:bO\u0016\u001cVM\u001d<jG\u0016\u0004B!!#\u0002\u00146\u0011\u00111\u0012\u0006\u0005\u0003\u001b\u000by)A\u0004tKJ4\u0018nY3\u000b\t\u0005E\u0015qH\u0001\bgR|'/Y4f\u0013\u0011\t)*a#\u0003\u001dM#xN]1hKN+'O^5dK\u0006Q1o]3TKJ4\u0018nY3\u0011\t\u0005m\u0015qT\u0007\u0003\u0003;SA!!$\u0002@%!\u0011\u0011UAO\u0005)\u00196/Z*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011\u0005\u001d\u0016\u0011VAV\u0003[\u00032!a \u0001\u0011\u001d\tY\b\u0002a\u0001\u0003{Bq!!\"\u0005\u0001\u0004\t9\tC\u0004\u0002\u0018\u0012\u0001\r!!'\u0002\u0017\u0015DXmY;uS>t\u0017\nZ\u000b\u0003\u0003g\u0003B!!.\u0002D:!\u0011qWA`!\u0011\tI,a\u0015\u000e\u0005\u0005m&\u0002BA_\u0003\u0017\na\u0001\u0010:p_Rt\u0014\u0002BAa\u0003'\na\u0001\u0015:fI\u00164\u0017\u0002BAc\u0003\u000f\u0014aa\u0015;sS:<'\u0002BAa\u0003'\nq\"\u001a=fGV$\u0018n\u001c8JI~#S-\u001d\u000b\u0005\u0003\u001b\f\u0019\u000e\u0005\u0003\u0002R\u0005=\u0017\u0002BAi\u0003'\u0012A!\u00168ji\"I\u0011Q\u001b\u0004\u0002\u0002\u0003\u0007\u00111W\u0001\u0004q\u0012\n\u0014\u0001D3yK\u000e,H/[8o\u0013\u0012\u0004\u0013A\u0002;bg.LE-\u0001\u0006uCN\\\u0017\nZ0%KF$B!!4\u0002`\"I\u0011Q[\u0005\u0002\u0002\u0003\u0007\u00111W\u0001\bi\u0006\u001c8.\u00133!\u0003Ia\u0017m\u001d;Fm\u0016tG\u000fV5nKN$\u0018-\u001c9\u0016\u0005\u0005\u001d\b\u0003BAu\u0003gl!!a;\u000b\t\u00055\u0018q^\u0001\u0005i&lWM\u0003\u0002\u0002r\u0006!!.\u0019<b\u0013\u0011\t)0a;\u0003\u000f%s7\u000f^1oi\u00061B.Y:u\u000bZ,g\u000e\u001e+j[\u0016\u001cH/Y7q?\u0012*\u0017\u000f\u0006\u0003\u0002N\u0006m\b\"CAk\u0019\u0005\u0005\t\u0019AAt\u0003Ma\u0017m\u001d;Fm\u0016tG\u000fV5nKN$\u0018-\u001c9!\u0003\u001d\u0011XmY3jm\u0016,\"Aa\u0001\u0011\t\t\u0015!qA\u0007\u0002\u0001%!!\u0011BA4\u0005\u001d\u0011VmY3jm\u0016\f\u0001\u0002]8tiN#x\u000e\u001d\u000b\u0003\u0003\u001b\fq\u0002[1oI2,w+\u0019;dQ6\u001bxm\u001d\u000b\u0005\u0003\u001b\u0014\u0019\u0002C\u0004\u0003\u0016A\u0001\rAa\u0006\u0002\u0015]\fGo\u00195fe6\u001bx\rE\u0002\u0003\u001ayq1Aa\u0007\u0014\u001d\u0011\u0011iB!\f\u000f\t\t}!1\u0006\b\u0005\u0005C\u0011IC\u0004\u0003\u0003$\t\u001db\u0002BA]\u0005KI!!!\u0013\n\t\u0005\u0015\u0013qI\u0005\u0005\u0003\u0003\n\u0019%\u0003\u0003\u0002>\u0005}\u0012\u0002BA\u001d\u0003w\ta#\u0012=fGV$\u0018n\u001c8M_\u001e<\u0016\r^2i\u0003\u000e$xN\u001d\t\u0004\u0003\u007f\"2c\u0001\u000b\u0002PQ\u0011!\u0011G\u0001\u001e\u0019>;ul\u0011%V\u001d.{VI\u0014+S3~\u001b%+R!U\u000b\u0012{VIV#O)\u0006qBjT$`\u0007\"+fjS0F\u001dR\u0013\u0016lX\"S\u000b\u0006#V\tR0F-\u0016sE\u000bI\u0001\u000f!&suiX*T\u000b~+e+\u0012(U\u0003=\u0001\u0016JT$`'N+u,\u0012,F\u001dR\u0003\u0013!C#O\t~+e+\u0012(U\u0003))e\nR0F-\u0016sE\u000bI\u0001\u001b\u000bb+5)\u0016+J\u001f:{FjT$`'R\u000bE+V*`\u000bZ+e\nV\u0001\u001c\u000bb+5)\u0016+J\u001f:{FjT$`'R\u000bE+V*`\u000bZ+e\n\u0016\u0011\u0003\u0015]\u000bGo\u00195fe6\u001bxmE\u0002\u001f\u0003\u001fJsAH+\u0002\u0004-\u0004CHA\u0003DQ\u0016\u001c7nE\u0005V\u0003\u001f\u0012\tF!\u0016\u0003\\A\u0019!1\u000b\u0010\u000e\u0003Q\u0001B!!\u0015\u0003X%!!\u0011LA*\u0005\u001d\u0001&o\u001c3vGR\u0004BA!\u0018\u0003h9!!q\fB2\u001d\u0011\tIL!\u0019\n\u0005\u0005U\u0013\u0002\u0002B3\u0003'\nq\u0001]1dW\u0006<W-\u0003\u0003\u0003j\t-$\u0001D*fe&\fG.\u001b>bE2,'\u0002\u0002B3\u0003'\"BAa\u001c\u0003rA\u0019!1K+\t\u000f\u0005=\u0006\f1\u0001\u00024\u0006!1m\u001c9z)\u0011\u0011yGa\u001e\t\u0013\u0005=\u0016\f%AA\u0002\u0005M\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005{RC!a-\u0003\u0000-\u0012!\u0011\u0011\t\u0005\u0005\u0007\u0013i)\u0004\u0002\u0003\u0006*!!q\u0011BE\u0003%)hn\u00195fG.,GM\u0003\u0003\u0003\f\u0006M\u0013AC1o]>$\u0018\r^5p]&!!q\u0012BC\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\tU\u0005\u0003\u0002BL\u0005;k!A!'\u000b\t\tm\u0015q^\u0001\u0005Y\u0006tw-\u0003\u0003\u0002F\ne\u0015\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001BR!\u0011\t\tF!*\n\t\t\u001d\u00161\u000b\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005[\u0013\u0019\f\u0005\u0003\u0002R\t=\u0016\u0002\u0002BY\u0003'\u00121!\u00118z\u0011%\t).XA\u0001\u0002\u0004\u0011\u0019+A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011I\f\u0005\u0004\u0003<\n\u0005'QV\u0007\u0003\u0005{SAAa0\u0002T\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t\r'Q\u0018\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003J\n=\u0007\u0003BA)\u0005\u0017LAA!4\u0002T\t9!i\\8mK\u0006t\u0007\"CAk?\u0006\u0005\t\u0019\u0001BW\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\tU%Q\u001b\u0005\n\u0003+\u0004\u0017\u0011!a\u0001\u0005G\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0005G\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005+\u000ba!Z9vC2\u001cH\u0003\u0002Be\u0005GD\u0011\"!6d\u0003\u0003\u0005\rA!,\u0003\u00119+w/\u00128uef\u001c\"\"a\u0001\u0002P\tE#Q\u000bB.\u0003-qWm^#oiJLXK]5\u0016\u0005\t5\b\u0003\u0002Bx\u0005kl!A!=\u000b\t\tM\u0018q^\u0001\u0004]\u0016$\u0018\u0002\u0002B|\u0005c\u00141!\u0016*J\u00031qWm^#oiJLXK]5!)\u0019\u0011iPa@\u0004\u0002A!!1KA\u0002\u0011!\ty+!\u0004A\u0002\u0005M\u0006\u0002\u0003Bu\u0003\u001b\u0001\rA!<\u0015\r\tu8QAB\u0004\u0011)\ty+a\u0004\u0011\u0002\u0003\u0007\u00111\u0017\u0005\u000b\u0005S\fy\u0001%AA\u0002\t5\u0018AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0007\u001bQCA!<\u0003\u0000Q!!QVB\t\u0011)\t).!\u0007\u0002\u0002\u0003\u0007!1\u0015\u000b\u0005\u0005\u0013\u001c)\u0002\u0003\u0006\u0002V\u0006u\u0011\u0011!a\u0001\u0005[#BA!&\u0004\u001a!Q\u0011Q[A\u0010\u0003\u0003\u0005\rAa)\u0015\t\t%7Q\u0004\u0005\u000b\u0003+\f)#!AA\u0002\t5&\u0001\u0002)p]\u001e\u001c\u0012b[A(\u0005#\u0012)Fa\u0017\u0015\t\r\u00152q\u0005\t\u0004\u0005'Z\u0007bBAX]\u0002\u0007\u00111\u0017\u000b\u0005\u0007K\u0019Y\u0003C\u0005\u00020>\u0004\n\u00111\u0001\u00024R!!QVB\u0018\u0011%\t)n]A\u0001\u0002\u0004\u0011\u0019\u000b\u0006\u0003\u0003J\u000eM\u0002\"CAkk\u0006\u0005\t\u0019\u0001BW)\u0011\u0011)ja\u000e\t\u0013\u0005Ug/!AA\u0002\t\rF\u0003\u0002Be\u0007wA\u0011\"!6z\u0003\u0003\u0005\rA!,\u0003\u0015M#\u0018M\u001d;XCR\u001c\u0007nE\u0006!\u0003\u001f\u0012\tf!\u0011\u0003V\tm\u0003\u0003BA/\u0007\u0007JAa!\u0012\u0002`\t\tcj\\*fe&\fG.\u001b>bi&|gNV3sS\u001aL7-\u0019;j_:tU-\u001a3fI\u0006AQo]3s]\u0006lW-A\u0005vg\u0016\u0014h.Y7fAQA1QJB(\u0007#\u001a\u0019\u0006E\u0002\u0003T\u0001Bq!!7(\u0001\u0004\t\u0019\fC\u0004\u00020\u001e\u0002\r!a-\t\u000f\r\u001ds\u00051\u0001\u00024RA1QJB,\u00073\u001aY\u0006C\u0005\u0002Z\"\u0002\n\u00111\u0001\u00024\"I\u0011q\u0016\u0015\u0011\u0002\u0003\u0007\u00111\u0017\u0005\n\u0007\u000fB\u0003\u0013!a\u0001\u0003g\u000babY8qs\u0012\"WMZ1vYR$3\u0007\u0006\u0003\u0003.\u000e\u0005\u0004\"CAk]\u0005\u0005\t\u0019\u0001BR)\u0011\u0011Im!\u001a\t\u0013\u0005U\u0007'!AA\u0002\t5F\u0003\u0002BK\u0007SB\u0011\"!62\u0003\u0003\u0005\rAa)\u0015\t\t%7Q\u000e\u0005\n\u0003+$\u0014\u0011!a\u0001\u0005[\u0013Ab\u0015;pa^\u000bGo\u00195j]\u001e\u001c\u0012\u0002PA(\u0005#\u0012)Fa\u0017\u0016\u0005\rU\u0004CBA)\u0007o\n\u0019,\u0003\u0003\u0004z\u0005M#AB(qi&|g\u000e\u0006\u0004\u0004~\r}4\u0011\u0011\t\u0004\u0005'b\u0004bBAX\u0003\u0002\u0007\u00111\u0017\u0005\b\u0007\u000f\n\u0005\u0019AB;)\u0019\u0019ih!\"\u0004\b\"I\u0011q\u0016\"\u0011\u0002\u0003\u0007\u00111\u0017\u0005\n\u0007\u000f\u0012\u0005\u0013!a\u0001\u0007k*\"aa#+\t\rU$q\u0010\u000b\u0005\u0005[\u001by\tC\u0005\u0002V\u001e\u000b\t\u00111\u0001\u0003$R!!\u0011ZBJ\u0011%\t).SA\u0001\u0002\u0004\u0011i\u000b\u0006\u0003\u0003\u0016\u000e]\u0005\"CAk\u0015\u0006\u0005\t\u0019\u0001BR)\u0011\u0011Ima'\t\u0013\u0005UW*!AA\u0002\t5\u0016AC*uCJ$x+\u0019;dQB\u0019!1\u000b\u001c\u0014\u000bY\u001a\u0019ka,\u0011\u0019\r\u001561VAZ\u0003g\u000b\u0019l!\u0014\u000e\u0005\r\u001d&\u0002BBU\u0003'\nqA];oi&lW-\u0003\u0003\u0004.\u000e\u001d&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogA!1\u0011WB\\\u001b\t\u0019\u0019L\u0003\u0003\u00046\u0006=\u0018AA5p\u0013\u0011\u0011Iga-\u0015\u0005\r}\u0015!B1qa2LH\u0003CB'\u0007\u007f\u001b\tma1\t\u000f\u0005e\u0017\b1\u0001\u00024\"9\u0011qV\u001dA\u0002\u0005M\u0006bBB$s\u0001\u0007\u00111W\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019Im!5\u0011\r\u0005E3qOBf!)\t\tf!4\u00024\u0006M\u00161W\u0005\u0005\u0007\u001f\f\u0019F\u0001\u0004UkBdWm\r\u0005\n\u0007'T\u0014\u0011!a\u0001\u0007\u001b\n1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0019I\u000e\u0005\u0003\u0003\u0018\u000em\u0017\u0002BBo\u00053\u0013aa\u00142kK\u000e$\u0018\u0001D*u_B<\u0016\r^2iS:<\u0007c\u0001B*\u001fN)qj!:\u00040BQ1QUBt\u0003g\u001b)h! \n\t\r%8q\u0015\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DCABq)\u0019\u0019iha<\u0004r\"9\u0011q\u0016*A\u0002\u0005M\u0006bBB$%\u0002\u00071Q\u000f\u000b\u0005\u0007k\u001ci\u0010\u0005\u0004\u0002R\r]4q\u001f\t\t\u0003#\u001aI0a-\u0004v%!11`A*\u0005\u0019!V\u000f\u001d7fe!I11[*\u0002\u0002\u0003\u00071QP\u0001\u0006\u0007\",7m\u001b\t\u0004\u0005'*7#B3\u0005\u0006\r=\u0006\u0003CBS\t\u000f\t\u0019La\u001c\n\t\u0011%1q\u0015\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\fDC\u0001C\u0001)\u0011\u0011y\u0007b\u0004\t\u000f\u0005=\u0006\u000e1\u0001\u00024R!1Q\u000fC\n\u0011%\u0019\u0019.[A\u0001\u0002\u0004\u0011y'\u0001\u0003Q_:<\u0007c\u0001B*wN)1\u0010b\u0007\u00040BA1Q\u0015C\u0004\u0003g\u001b)\u0003\u0006\u0002\u0005\u0018Q!1Q\u0005C\u0011\u0011\u001d\tyK a\u0001\u0003g#Ba!\u001e\u0005&!I11[@\u0002\u0002\u0003\u00071QE\u0001\t\u001d\u0016<XI\u001c;ssB!!1KA\u0015'\u0019\tI\u0003\"\f\u00040BQ1QUBt\u0003g\u0013iO!@\u0015\u0005\u0011%BC\u0002B\u007f\tg!)\u0004\u0003\u0005\u00020\u0006=\u0002\u0019AAZ\u0011!\u0011I/a\fA\u0002\t5H\u0003\u0002C\u001d\t{\u0001b!!\u0015\u0004x\u0011m\u0002\u0003CA)\u0007s\f\u0019L!<\t\u0015\rM\u0017\u0011GA\u0001\u0002\u0004\u0011i0\u0001\ntiJ,\u0017-\\\"veJ,g\u000e^*uCR,G\u0003BAg\t\u0007Bq!a,\u0012\u0001\u0004\t\u0019,A\btiJ,\u0017-\u001c'bgR\u001c\u0005.\u001e8l)\u0011\ti\r\"\u0013\t\u000f\u0005=&\u00031\u0001\u00024\"\u001a\u0001\u0001\"\u0014\u0011\t\u0011=C1L\u0007\u0003\t#RA\u0001b\u0015\u0005V\u000511\u000f\u001d:j]\u001eTA!!\u001a\u0005X)!A\u0011LA \u0003\u001d\u0019X\u000f\u001d9peRLA\u0001\"\u0018\u0005R\tY1\u000b\u001d:j]\u001e\f5\r^8s\u0001")
public class ExecutionLogWatchActor
implements Actor,
SLF4JLogging {
    private final TaskExecutionLogService taskExecutionLogService;
    private final StorageService storageService;
    private final SseService sseService;
    private String executionId;
    private String taskId;
    private Instant lastEventTimestamp;
    private transient Logger log;
    private ActorContext context;
    private ActorRef self;
    private volatile transient boolean bitmap$trans$0;

    public static String EXECUTION_LOG_STATUS_EVENT() {
        return ExecutionLogWatchActor$.MODULE$.EXECUTION_LOG_STATUS_EVENT();
    }

    public static String END_EVENT() {
        return ExecutionLogWatchActor$.MODULE$.END_EVENT();
    }

    public static String PING_SSE_EVENT() {
        return ExecutionLogWatchActor$.MODULE$.PING_SSE_EVENT();
    }

    public static String LOG_CHUNK_ENTRY_CREATED_EVENT() {
        return ExecutionLogWatchActor$.MODULE$.LOG_CHUNK_ENTRY_CREATED_EVENT();
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preStart() throws Exception {
        Actor.preStart$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    private Logger log$lzycompute() {
        ExecutionLogWatchActor executionLogWatchActor = this;
        synchronized (executionLogWatchActor) {
            if (!this.bitmap$trans$0) {
                this.log = SLF4JLogging.log$((SLF4JLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public String executionId() {
        return this.executionId;
    }

    public void executionId_$eq(String x$1) {
        this.executionId = x$1;
    }

    public String taskId() {
        return this.taskId;
    }

    public void taskId_$eq(String x$1) {
        this.taskId = x$1;
    }

    public Instant lastEventTimestamp() {
        return this.lastEventTimestamp;
    }

    public void lastEventTimestamp_$eq(Instant x$1) {
        this.lastEventTimestamp = x$1;
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return LoggingReceive$.MODULE$.apply((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutionLogWatchActor $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof WatcherMsg) {
                    WatcherMsg watcherMsg = (WatcherMsg)A1;
                    this.$outer.com$xebialabs$xlrelease$scheduler$logs$ExecutionLogWatchActor$$handleWatchMsgs(watcherMsg);
                    return (B1)BoxedUnit.UNIT;
                }
                if (ReceiveTimeout$.MODULE$.equals(A1)) {
                    this.$outer.self().$bang((Object)new Check(this.$outer.executionId()), this.$outer.self());
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (object instanceof WatcherMsg) {
                    return true;
                }
                return ReceiveTimeout$.MODULE$.equals(object);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.context());
    }

    public void postStop() {
        if (this.executionId() != null) {
            this.sseService.sendEvent(this.executionId(), ExecutionLogWatchActor$.MODULE$.END_EVENT(), "");
            this.sseService.unsubscribeAllUsers(this.executionId());
            return;
        }
    }

    public void com$xebialabs$xlrelease$scheduler$logs$ExecutionLogWatchActor$$handleWatchMsgs(WatcherMsg watcherMsg) {
        boolean bl = false;
        StopWatching stopWatching = null;
        WatcherMsg watcherMsg2 = watcherMsg;
        if (watcherMsg2 instanceof StartWatch) {
            StartWatch startWatch = (StartWatch)watcherMsg2;
            String taskId = startWatch.taskId();
            String executionId = startWatch.executionId();
            String username = startWatch.username();
            this.executionId_$eq(executionId);
            this.taskId_$eq(taskId);
            this.sseService.subscribeTopicToUser(executionId, username);
            this.streamCurrentState(executionId);
            this.streamLastChunk(executionId);
            this.self().$bang((Object)new Check(executionId), this.self());
            return;
        }
        if (watcherMsg2 instanceof StopWatching) {
            bl = true;
            stopWatching = (StopWatching)watcherMsg2;
            String executionId = stopWatching.executionId();
            Option<String> option = stopWatching.username();
            if (option instanceof Some) {
                Some some = (Some)option;
                String username = (String)some.value();
                this.sseService.unsubscribeTopicToUser(executionId, username);
                this.self().$bang((Object)new Check(executionId), this.self());
                return;
            }
        }
        if (bl) {
            String executionId = stopWatching.executionId();
            Option<String> option = stopWatching.username();
            if (None$.MODULE$.equals(option)) {
                this.sseService.sendEvent(executionId, ExecutionLogWatchActor$.MODULE$.END_EVENT(), "");
                this.sseService.unsubscribeAllUsers(executionId);
                this.self().$bang((Object)new Check(executionId), this.self());
                return;
            }
        }
        if (watcherMsg2 instanceof Pong) {
            this.lastEventTimestamp_$eq(Instant.now());
            return;
        }
        if (watcherMsg2 instanceof Check) {
            Check check = (Check)watcherMsg2;
            String executionId = check.executionId();
            boolean hasUsersFollowingExecution = this.sseService.hasActiveUsers(executionId);
            if (!hasUsersFollowingExecution) {
                this.context().stop(this.self());
                return;
            }
            Option<TaskExecutionEntry> maybeExecutionEntry = this.taskExecutionLogService.getTaskExecutionEntry(this.taskId(), executionId);
            boolean executionIsCompletedOrMissing = maybeExecutionEntry.forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ExecutionLogWatchActor.$anonfun$handleWatchMsgs$1(x$3)));
            if (executionIsCompletedOrMissing) {
                this.self().$bang((Object)new StopWatching(executionId, (Option<String>)None$.MODULE$), this.self());
                return;
            }
            long durationSinceLastEvent = java.time.Duration.between(this.lastEventTimestamp(), Instant.now()).toSeconds();
            if (durationSinceLastEvent > 10L && durationSinceLastEvent < 60L) {
                this.sseService.sendEvent(executionId, ExecutionLogWatchActor$.MODULE$.PING_SSE_EVENT(), new String(":\n\n"));
                return;
            }
            if (durationSinceLastEvent >= 60L) {
                this.self().$bang((Object)new StopWatching(executionId, (Option<String>)None$.MODULE$), this.self());
                return;
            }
            return;
        }
        if (watcherMsg2 instanceof NewEntry) {
            NewEntry newEntry = (NewEntry)watcherMsg2;
            String executionId = newEntry.executionId();
            URI newEntryUri = newEntry.newEntryUri();
            this.lastEventTimestamp_$eq(Instant.now());
            byte[] payload = (byte[])Using$.MODULE$.resource((Object)this.storageService.get((StorageEntryRef)new JobEntryRef(newEntryUri)), (Function1 & Serializable)content -> IOUtils.toByteArray((InputStream)content), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            this.sseService.sendEvent(executionId, ExecutionLogWatchActor$.MODULE$.LOG_CHUNK_ENTRY_CREATED_EVENT(), new String(payload));
            return;
        }
        throw new MatchError((Object)watcherMsg2);
    }

    private void streamCurrentState(String executionId) {
        Tuple3 tuple3;
        Option<TaskExecutionEntry> option = this.taskExecutionLogService.getTaskExecutionEntry(this.taskId(), executionId);
        if (option instanceof Some) {
            Some some = (Some)option;
            TaskExecutionEntry row = (TaskExecutionEntry)some.value();
            tuple3 = new Tuple3((Object)(row.endDate() == null ? "in_progress" : "closed"), (Object)BoxesRunTime.boxToInteger((int)row.lastJob()), (Object)BoxesRunTime.boxToInteger((int)row.lastChunk()));
        } else if (None$.MODULE$.equals(option)) {
            tuple3 = new Tuple3((Object)"unknown", (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToInteger((int)-1));
        } else {
            throw new MatchError(option);
        }
        Tuple3 tuple32 = tuple3;
        if (tuple32 == null) {
            throw new MatchError((Object)tuple32);
        }
        String status = (String)tuple32._1();
        int jobId = BoxesRunTime.unboxToInt((Object)tuple32._2());
        int chunk = BoxesRunTime.unboxToInt((Object)tuple32._3());
        Tuple3 tuple33 = new Tuple3((Object)status, (Object)BoxesRunTime.boxToInteger((int)jobId), (Object)BoxesRunTime.boxToInteger((int)chunk));
        String status2 = (String)tuple33._1();
        int jobId2 = BoxesRunTime.unboxToInt((Object)tuple33._2());
        int chunk2 = BoxesRunTime.unboxToInt((Object)tuple33._3());
        String payload = status2 + ", " + jobId2 + ", " + chunk2;
        this.sseService.sendEvent(executionId, ExecutionLogWatchActor$.MODULE$.EXECUTION_LOG_STATUS_EVENT(), new String(payload));
    }

    private void streamLastChunk(String executionId) {
        Option<TaskExecutionEntry> maybeRow = this.taskExecutionLogService.getTaskExecutionEntry(this.taskId(), executionId);
        maybeRow.foreach((Function1 & Serializable)row -> {
            ExecutionLogWatchActor.$anonfun$streamLastChunk$1(this, row);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$handleWatchMsgs$1(TaskExecutionEntry x$3) {
        return x$3.endDate() != null;
    }

    public static final /* synthetic */ void $anonfun$streamLastChunk$1(ExecutionLogWatchActor $this, TaskExecutionEntry row) {
        String taskIdHash = row.taskIdHash();
        String executionId = row.executionId();
        int jobId = row.lastJob();
        int chunk = row.lastChunk();
        String uriPath = "/jobs/" + taskIdHash + "/" + executionId + "/" + jobId + "/" + chunk;
        String uriScheme = "xlr-local";
        URI entryUri = URI.create(uriScheme + "://" + uriPath);
        byte[] payload = (byte[])Using$.MODULE$.resource((Object)$this.storageService.get((StorageEntryRef)new JobEntryRef(entryUri)), (Function1 & Serializable)content -> IOUtils.toByteArray((InputStream)content), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        $this.sseService.sendEvent(executionId, ExecutionLogWatchActor$.MODULE$.LOG_CHUNK_ENTRY_CREATED_EVENT(), new String(payload));
    }

    public ExecutionLogWatchActor(TaskExecutionLogService taskExecutionLogService, StorageService storageService, SseService sseService) {
        this.taskExecutionLogService = taskExecutionLogService;
        this.storageService = storageService;
        this.sseService = sseService;
        Actor.$init$((Actor)this);
        SLF4JLogging.$init$((SLF4JLogging)this);
        this.lastEventTimestamp = Instant.now();
        this.context().setReceiveTimeout((Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds());
        Statics.releaseFence();
    }

    public static class Check
    implements WatcherMsg,
    Product,
    Serializable {
        private final String executionId;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public String executionId() {
            return this.executionId;
        }

        public Check copy(String executionId) {
            return new Check(executionId);
        }

        public String copy$default$1() {
            return this.executionId();
        }

        public String productPrefix() {
            return "Check";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.executionId();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Check;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "executionId";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Check)) return false;
            boolean bl = true;
            if (!bl) return false;
            Check check = (Check)x$1;
            String string = this.executionId();
            String string2 = check.executionId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!check.canEqual(this)) return false;
            return true;
        }

        public Check(String executionId) {
            this.executionId = executionId;
            Product.$init$((Product)this);
        }
    }

    public static class NewEntry
    implements WatcherMsg,
    Product,
    Serializable {
        private final String executionId;
        private final URI newEntryUri;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public String executionId() {
            return this.executionId;
        }

        public URI newEntryUri() {
            return this.newEntryUri;
        }

        public NewEntry copy(String executionId, URI newEntryUri) {
            return new NewEntry(executionId, newEntryUri);
        }

        public String copy$default$1() {
            return this.executionId();
        }

        public URI copy$default$2() {
            return this.newEntryUri();
        }

        public String productPrefix() {
            return "NewEntry";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.executionId();
                }
                case 1: {
                    return this.newEntryUri();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof NewEntry;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "executionId";
                }
                case 1: {
                    return "newEntryUri";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof NewEntry)) return false;
            boolean bl = true;
            if (!bl) return false;
            NewEntry newEntry = (NewEntry)x$1;
            String string = this.executionId();
            String string2 = newEntry.executionId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            URI uRI = this.newEntryUri();
            URI uRI2 = newEntry.newEntryUri();
            if (uRI == null) {
                if (uRI2 != null) {
                    return false;
                }
            } else if (!((Object)uRI).equals(uRI2)) return false;
            if (!newEntry.canEqual(this)) return false;
            return true;
        }

        public NewEntry(String executionId, URI newEntryUri) {
            this.executionId = executionId;
            this.newEntryUri = newEntryUri;
            Product.$init$((Product)this);
        }
    }

    public static class Pong
    implements WatcherMsg,
    Product,
    Serializable {
        private final String executionId;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public String executionId() {
            return this.executionId;
        }

        public Pong copy(String executionId) {
            return new Pong(executionId);
        }

        public String copy$default$1() {
            return this.executionId();
        }

        public String productPrefix() {
            return "Pong";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.executionId();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Pong;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "executionId";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Pong)) return false;
            boolean bl = true;
            if (!bl) return false;
            Pong pong = (Pong)x$1;
            String string = this.executionId();
            String string2 = pong.executionId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!pong.canEqual(this)) return false;
            return true;
        }

        public Pong(String executionId) {
            this.executionId = executionId;
            Product.$init$((Product)this);
        }
    }

    public static class StartWatch
    implements WatcherMsg,
    NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final String taskId;
        private final String executionId;
        private final String username;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String taskId() {
            return this.taskId;
        }

        @Override
        public String executionId() {
            return this.executionId;
        }

        public String username() {
            return this.username;
        }

        public StartWatch copy(String taskId, String executionId, String username) {
            return new StartWatch(taskId, executionId, username);
        }

        public String copy$default$1() {
            return this.taskId();
        }

        public String copy$default$2() {
            return this.executionId();
        }

        public String copy$default$3() {
            return this.username();
        }

        public String productPrefix() {
            return "StartWatch";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.taskId();
                }
                case 1: {
                    return this.executionId();
                }
                case 2: {
                    return this.username();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof StartWatch;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "taskId";
                }
                case 1: {
                    return "executionId";
                }
                case 2: {
                    return "username";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof StartWatch)) return false;
            boolean bl = true;
            if (!bl) return false;
            StartWatch startWatch = (StartWatch)x$1;
            String string = this.taskId();
            String string2 = startWatch.taskId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.executionId();
            String string4 = startWatch.executionId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.username();
            String string6 = startWatch.username();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            if (!startWatch.canEqual(this)) return false;
            return true;
        }

        public StartWatch(String taskId, String executionId, String username) {
            this.taskId = taskId;
            this.executionId = executionId;
            this.username = username;
            Product.$init$((Product)this);
        }
    }

    public static class StopWatching
    implements WatcherMsg,
    Product,
    Serializable {
        private final String executionId;
        private final Option<String> username;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public String executionId() {
            return this.executionId;
        }

        public Option<String> username() {
            return this.username;
        }

        public StopWatching copy(String executionId, Option<String> username) {
            return new StopWatching(executionId, username);
        }

        public String copy$default$1() {
            return this.executionId();
        }

        public Option<String> copy$default$2() {
            return this.username();
        }

        public String productPrefix() {
            return "StopWatching";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.executionId();
                }
                case 1: {
                    return this.username();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof StopWatching;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "executionId";
                }
                case 1: {
                    return "username";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof StopWatching)) return false;
            boolean bl = true;
            if (!bl) return false;
            StopWatching stopWatching = (StopWatching)x$1;
            String string = this.executionId();
            String string2 = stopWatching.executionId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<String> option = this.username();
            Option<String> option2 = stopWatching.username();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!stopWatching.canEqual(this)) return false;
            return true;
        }

        public StopWatching(String executionId, Option<String> username) {
            this.executionId = executionId;
            this.username = username;
            Product.$init$((Product)this);
        }
    }

    public static interface WatcherMsg {
        public String executionId();
    }
}

