package com.xebialabs.xlrelease.views;

import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseKind;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdDeserializer;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdSerializer;

import static java.util.stream.Collectors.toList;

public class ReleaseView {

    private ReleaseKind kind;

    @JsonSerialize(using = DomainIdSerializer.class)
    @JsonDeserialize(using = DomainIdDeserializer.class)
    private String id;

    private String title;

    private Map<String, String> variables;

    private List<PhaseView> phases;

    public ReleaseView(Release release) {
        this.id = release.getId();
        this.title  = release.getTitle();
        this.phases = release.getPhases().stream().map(PhaseView::new).collect(toList());
        this.variables = release.getAllStringVariableValues();
        this.kind = release.getKind();
    }

    public String getId() {
        return id;
    }

    public String getTitle() {
        return title;
    }

    public Map<String, String> getVariables() {
        return variables;
    }

    public List<PhaseView> getPhases() {
        return phases;
    }

    public ReleaseKind getKind() {
        return kind;
    }
}
