package liquibase.database.ext

import liquibase.database.ObjectQuotingStrategy
import liquibase.database.core.PostgresDatabase
import liquibase.structure.DatabaseObject

/**
 * We don't want to use quoting for PostgresDatabase
 */
trait PostgresQuoteSupport extends PostgresDatabase {

  /**
   * scala and java protected party
   */
  override def mustQuoteObjectName(objectName: String, objectType: Class[_ <: DatabaseObject]): Boolean = super.mustQuoteObjectName(objectName, objectType)


  override def escapeObjectName(objectName: String, objectType: Class[_ <: DatabaseObject]): String = {
    var escapedObjectName = objectName
    if (escapedObjectName != null) {
      escapedObjectName = escapedObjectName.trim
      if (mustQuoteObjectName(escapedObjectName, objectType)) {
        escapedObjectName = quoteObject(escapedObjectName, objectType)
      } else if (getObjectQuotingStrategy == ObjectQuotingStrategy.QUOTE_ALL_OBJECTS) {
        escapedObjectName = quoteObject(escapedObjectName, objectType)
      }
      escapedObjectName = escapedObjectName.trim
    }
    escapedObjectName
  }
}
