package com.xebialabs.xlrelease.repository

import com.xebialabs.xlrelease.domain.ReleaseKind
import com.xebialabs.xlrelease.domain.status.ReleaseStatus

case class ReleaseInformation(releaseId: String, kind: ReleaseKind, status: ReleaseStatus, isArchived: Boolean, owner: Option[String]) {
  def isWorkflowExecution(): Boolean = {
    if (this.isArchived) {
      this.kind == ReleaseKind.WORKFLOW
    } else {
      this.status != ReleaseStatus.TEMPLATE && this.kind == ReleaseKind.WORKFLOW
    }
  }

  def isTemplate(): Boolean = {
    status == ReleaseStatus.TEMPLATE
  }

  def isWorkflow(): Boolean = {
    kind == ReleaseKind.WORKFLOW
  }
}