/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security.authentication;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plumbing.authentication.InternalUser;
import com.xebialabs.deployit.security.User;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;
import com.xebialabs.xlrelease.domain.UserToken;
import com.xebialabs.xlrelease.principaldata.PrincipalDataProvider;
import com.xebialabs.xlrelease.principaldata.UserData;
import com.xebialabs.xlrelease.security.authentication.PersonalAuthenticationToken;
import com.xebialabs.xlrelease.security.authentication.TokenExpiredException;
import com.xebialabs.xlrelease.service.UserLastActiveActorService;
import com.xebialabs.xlrelease.service.UserTokenService;
import com.xebialabs.xlrelease.utils.DateVariableUtils;
import com.xebialabs.xlrelease.utils.TokenGenerator$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Marker;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.NullAuthoritiesMapper;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component(value="xlAuthenticationProvider")
@ScalaSignature(bytes="\u0006\u0005\u0005}f\u0001\u0002\t\u0012\u0001qA\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"Aa\t\u0001B\u0001B\u0003%q\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u001dI\u0006\u00011A\u0005\niCq!\u001a\u0001A\u0002\u0013%a\r\u0003\u0004p\u0001\u0001\u0006Ka\u0017\u0005\u0006a\u0002!\t%\u001d\u0005\b\u0003\u0017\u0002A\u0011BA'\u0011\u001d\t\t\u0006\u0001C\u0005\u0003'Bq!!\u0018\u0001\t\u0013\ty\u0006C\u0004\u0002\u0002\u0002!\t%a!\t\r\u0005\r\u0006\u0001\"\u0001[\u0011\u001d\t)\u000b\u0001C\u0001\u0003O\u0013QDU3mK\u0006\u001cX-Q;uQ\u0016tG/[2bi&|g\u000e\u0015:pm&$WM\u001d\u0006\u0003%M\ta\"Y;uQ\u0016tG/[2bi&|gN\u0003\u0002\u0015+\u0005A1/Z2ve&$\u0018P\u0003\u0002\u0017/\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u00031e\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003i\t1aY8n\u0007\u0001\u0019B\u0001A\u000f&_A\u0011adI\u0007\u0002?)\u0011\u0001%I\u0001\u0005Y\u0006twMC\u0001#\u0003\u0011Q\u0017M^1\n\u0005\u0011z\"AB(cU\u0016\u001cG\u000f\u0005\u0002'[5\tqE\u0003\u0002\u0013Q)\u0011A#\u000b\u0006\u0003U-\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002Y\u0005\u0019qN]4\n\u00059:#AF!vi\",g\u000e^5dCRLwN\u001c)s_ZLG-\u001a:\u0011\u0005A*T\"A\u0019\u000b\u0005I\u001a\u0014!B:mMRR'\"\u0001\u001b\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!AN\u0019\u0003\u000f1{wmZ5oO\u0006YQo]3s'\u0016\u0014h/[2f!\tIT(D\u0001;\u0015\t!2H\u0003\u0002=/\u0005AA-\u001a9m_fLG/\u0003\u0002?u\tYQk]3s'\u0016\u0014h/[2f\u0003A)8/\u001a:U_.,gnU3sm&\u001cW\r\u0005\u0002B\t6\t!I\u0003\u0002D+\u000591/\u001a:wS\u000e,\u0017BA#C\u0005A)6/\u001a:U_.,gnU3sm&\u001cW-\u0001\u000evg\u0016\u0014H*Y:u\u0003\u000e$\u0018N^3BGR|'oU3sm&\u001cW\r\u0005\u0002B\u0011&\u0011\u0011J\u0011\u0002\u001b+N,'\u000fT1ti\u0006\u001bG/\u001b<f\u0003\u000e$xN]*feZL7-Z\u0001\u0016aJLgnY5qC2$\u0015\r^1Qe>4\u0018\u000eZ3s!\tau*D\u0001N\u0015\tqU#A\u0007qe&t7-\u001b9bY\u0012\fG/Y\u0005\u0003!6\u0013Q\u0003\u0015:j]\u000eL\u0007/\u00197ECR\f\u0007K]8wS\u0012,'/\u0001\u0004=S:LGO\u0010\u000b\u0006'V3v\u000b\u0017\t\u0003)\u0002i\u0011!\u0005\u0005\u0006o\u0015\u0001\r\u0001\u000f\u0005\u0006\u007f\u0015\u0001\r\u0001\u0011\u0005\u0006\r\u0016\u0001\ra\u0012\u0005\u0006\u0015\u0016\u0001\raS\u0001\u0012CV$\bn\u001c:ji&,7/T1qa\u0016\u0014X#A.\u0011\u0005q\u001bW\"A/\u000b\u0005y{\u0016aB7baBLgn\u001a\u0006\u0003A\u0006\f\u0011\"Y;uQ>\u0014\u0018\u000e^=\u000b\u0005\tD\u0013\u0001B2pe\u0016L!\u0001Z/\u00031\u001d\u0013\u0018M\u001c;fI\u0006+H\u000f[8sSRLWm]'baB,'/A\u000bbkRDwN]5uS\u0016\u001cX*\u00199qKJ|F%Z9\u0015\u0005\u001dl\u0007C\u00015l\u001b\u0005I'\"\u00016\u0002\u000bM\u001c\u0017\r\\1\n\u00051L'\u0001B+oSRDqA\\\u0004\u0002\u0002\u0003\u00071,A\u0002yIE\n!#Y;uQ>\u0014\u0018\u000e^5fg6\u000b\u0007\u000f]3sA\u0005a\u0011-\u001e;iK:$\u0018nY1uKR\u0011!O\u001e\t\u0003gRl\u0011!Y\u0005\u0003k\u0006\u0014a\"Q;uQ\u0016tG/[2bi&|g\u000eC\u0003x\u0013\u0001\u0007!/A\u0003u_.,g\u000eK\u0002\ns~\u00042\u0001\u001b>}\u0013\tY\u0018N\u0001\u0004uQJ|wo\u001d\t\u0003gvL!A`1\u0003/\u0005+H\u000f[3oi&\u001c\u0017\r^5p]\u0016C8-\u001a9uS>t\u0017g\u0002\u0010\u0002\u0002\u0005]\u0011\u0011\n\t\u0005\u0003\u0007\t\tB\u0004\u0003\u0002\u0006\u00055\u0001cAA\u0004S6\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017Y\u0012A\u0002\u001fs_>$h(C\u0002\u0002\u0010%\fa\u0001\u0015:fI\u00164\u0017\u0002BA\n\u0003+\u0011aa\u0015;sS:<'bAA\bSFJ1%!\u0007\u0002\"\u0005}\u00121E\u000b\u0005\u00037\ti\"\u0006\u0002\u0002\u0002\u00119\u0011qD\u000eC\u0002\u0005%\"!\u0001+\n\t\u0005\r\u0012QE\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u000b\u0007\u0005\u001d\u0012.\u0001\u0004uQJ|wo]\t\u0005\u0003W\t\t\u0004E\u0002i\u0003[I1!a\fj\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!a\r\u0002:9\u0019\u0001.!\u000e\n\u0007\u0005]\u0012.A\u0004qC\u000e\\\u0017mZ3\n\t\u0005m\u0012Q\b\u0002\n)\"\u0014xn^1cY\u0016T1!a\u000ejc%\u0019\u0013\u0011IA\"\u0003\u000b\n9CD\u0002i\u0003\u0007J1!a\njc\u0015\u0011\u0003.[A$\u0005\u0015\u00198-\u00197bc\t1C0A\rbkRDWM\u001c;jG\u0006$XM\u0012:p[V\u001bXM\u001d+pW\u0016tGc\u0001:\u0002P!1qO\u0003a\u0001\u0003\u0003\t1$Y;uQ\u0016tG/[2bi\u00164%o\\7De\u0016$WM\u001c;jC2\u001cH#\u0002:\u0002V\u0005e\u0003bBA,\u0017\u0001\u0007\u0011\u0011A\u0001\tkN,'O\\1nK\"9\u00111L\u0006A\u0002\u0005\u0005\u0011\u0001\u00039bgN<xN\u001d3\u0002'\u00154\u0018\r\\;bi\u0016\fU\u000f\u001e5pe&$\u0018.Z:\u0015\t\u0005\u0005\u0014q\u0010\u0019\u0005\u0003G\n\u0019\b\u0005\u0004\u0002f\u0005-\u0014qN\u0007\u0003\u0003OR1!!\u001b\"\u0003\u0011)H/\u001b7\n\t\u00055\u0014q\r\u0002\u000b\u0007>dG.Z2uS>t\u0007\u0003BA9\u0003gb\u0001\u0001B\u0006\u0002v1\t\t\u0011!A\u0003\u0002\u0005]$aA0%gE!\u00111FA=!\r\u0019\u00181P\u0005\u0004\u0003{\n'\u0001E$sC:$X\rZ!vi\"|'/\u001b;z\u0011\u001d\t9\u0006\u0004a\u0001\u0003\u0003\t\u0001b];qa>\u0014Ho\u001d\u000b\u0005\u0003\u000b\u000bY\tE\u0002i\u0003\u000fK1!!#j\u0005\u001d\u0011un\u001c7fC:DaAE\u0007A\u0002\u00055\u0005\u0007BAH\u0003/\u0003b!a\u0001\u0002\u0012\u0006U\u0015\u0002BAJ\u0003+\u0011Qa\u00117bgN\u0004B!!\u001d\u0002\u0018\u0012a\u0011\u0011TAF\u0003\u0003\u0005\tQ!\u0001\u0002\u001c\n\u0019q\f\n\u001b\u0012\t\u0005-\u0012Q\u0014\t\u0004Q\u0006}\u0015bAAQS\n\u0019\u0011I\\=\u0002)\u001d,G/Q;uQ>\u0014\u0018\u000e^5fg6\u000b\u0007\u000f]3s\u0003Q\u0019X\r^!vi\"|'/\u001b;jKNl\u0015\r\u001d9feR\u0019q-!+\t\u000be{\u0001\u0019A.)\u000f\u0001\ti+!/\u0002<B!\u0011qVA[\u001b\t\t\tLC\u0002\u00024&\n!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\t9,!-\u0003\u0013\r{W\u000e]8oK:$\u0018!\u0002<bYV,\u0017EAA_\u0003aAH.Q;uQ\u0016tG/[2bi&|g\u000e\u0015:pm&$WM\u001d")
public class ReleaseAuthenticationProvider
implements AuthenticationProvider,
Logging {
    private final UserService userService;
    private final UserTokenService userTokenService;
    private final UserLastActiveActorService userLastActiveActorService;
    private final PrincipalDataProvider principalDataProvider;
    private GrantedAuthoritiesMapper authoritiesMapper;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReleaseAuthenticationProvider releaseAuthenticationProvider = this;
        synchronized (releaseAuthenticationProvider) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private GrantedAuthoritiesMapper authoritiesMapper() {
        return this.authoritiesMapper;
    }

    private void authoritiesMapper_$eq(GrantedAuthoritiesMapper x$1) {
        this.authoritiesMapper = x$1;
    }

    public Authentication authenticate(Authentication token) throws AuthenticationException {
        Authentication authentication;
        this.logger().debug((Function0 & Serializable)() -> "Authenticating for Digital.ai Release");
        try {
            authentication = token instanceof PersonalAuthenticationToken ? this.authenticateFromUserToken(token.getCredentials().toString()) : this.authenticateFromCredentials(token.getPrincipal().toString(), token.getCredentials().toString());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof AuthenticationFailureException ? true : throwable2 instanceof NotFoundException) {
                throw new BadCredentialsException(throwable2.getMessage(), throwable2);
            }
            throw throwable;
        }
        return authentication;
    }

    private Authentication authenticateFromUserToken(String token) {
        this.logger().trace((Function0 & Serializable)() -> "Authenticating using personal access token");
        String tokenHash = TokenGenerator$.MODULE$.hash(token);
        UserToken userToken = (UserToken)this.userTokenService.findByUserToken(tokenHash).getOrElse((Function0 & Serializable)() -> {
            throw new AuthenticationFailureException("Cannot authenticate with supplied personal access token");
        });
        if (userToken.isExpired()) {
            throw new TokenExpiredException("The token expired on " + DateVariableUtils.printDate((Date)userToken.expiryDate()));
        }
        this.userLastActiveActorService.updateTokenLastUsed(userToken.ciUid());
        Collection<? extends GrantedAuthority> mappedAuthorities = this.evaluateAuthorities(userToken.username());
        return new PersonalAuthenticationToken(new InternalUser(userToken.username()), token, mappedAuthorities);
    }

    private Authentication authenticateFromCredentials(String username, String password) {
        this.logger().trace((Function0 & Serializable)() -> "Authenticating [" + username + "]");
        if (Strings.isBlank((String)username)) {
            throw new BadCredentialsException("Cannot authenticate with empty username");
        }
        this.userService.authenticate(username, password);
        Collection<? extends GrantedAuthority> mappedAuthorities = this.evaluateAuthorities(username);
        return new UsernamePasswordAuthenticationToken((Object)new InternalUser(username), (Object)password, mappedAuthorities);
    }

    private Collection<? extends GrantedAuthority> evaluateAuthorities(String username) {
        UserData userData = this.principalDataProvider.getUserData(username);
        if (userData.isFound()) {
            return this.authoritiesMapper().mapAuthorities(this.principalDataProvider.getAuthorities(username));
        }
        User user = this.userService.read(username);
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        Object object = user.isAdmin() || "admin".equals(user.getUsername()) ? BoxesRunTime.boxToBoolean((boolean)authorities.add(new SimpleGrantedAuthority("ROLE_ADMIN"))) : BoxedUnit.UNIT;
        return this.authoritiesMapper().mapAuthorities(authorities);
    }

    public boolean supports(Class<?> authentication) {
        return authentication.isAssignableFrom(UsernamePasswordAuthenticationToken.class) || authentication.isAssignableFrom(PersonalAuthenticationToken.class);
    }

    public GrantedAuthoritiesMapper getAuthoritiesMapper() {
        return this.authoritiesMapper();
    }

    public void setAuthoritiesMapper(GrantedAuthoritiesMapper authoritiesMapper) {
        this.authoritiesMapper_$eq(authoritiesMapper);
    }

    public ReleaseAuthenticationProvider(UserService userService, UserTokenService userTokenService, UserLastActiveActorService userLastActiveActorService, PrincipalDataProvider principalDataProvider) {
        this.userService = userService;
        this.userTokenService = userTokenService;
        this.userLastActiveActorService = userLastActiveActorService;
        this.principalDataProvider = principalDataProvider;
        Logging.$init$((Logging)this);
        this.authoritiesMapper = new NullAuthoritiesMapper();
    }
}

