/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.api.v1.forms.CreatePersonalAccessTokenForm;
import com.xebialabs.xlrelease.domain.UserToken;
import com.xebialabs.xlrelease.principaldata.PrincipalDataProvider;
import com.xebialabs.xlrelease.principaldata.UserData;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.UserTokenService;
import com.xebialabs.xlrelease.service.Users;
import com.xebialabs.xlrelease.user.User;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@Path(value="/tokens")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@ScalaSignature(bytes="\u0006\u0005\t=a\u0001B\u0007\u000f\u0001eA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u0015A\u0006\u0001\"\u0001Z\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!!\u001d\u0001\t\u0003\t\u0019\bC\u0004\u0002r\u0001!\t!a&\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002$\"9\u00111\u001b\u0001\u0005\n\u0005U\u0007B\u0002-\u0001\t\u0013\tYNA\tVg\u0016\u0014Hk\\6f]J+7o\\;sG\u0016T!a\u0004\t\u0002\u0011%tG/\u001a:oC2T!!\u0005\n\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0014)\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003+Y\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003]\t1aY8n\u0007\u0001\u00192\u0001\u0001\u000e!!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0019\te.\u001f*fMB\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0006g24GG\u001b\u0006\u0002K\u0005AqM]5{u2,G-\u0003\u0002(E\t9Aj\\4hS:<\u0017a\u00039fe6L7o]5p]N\u0004\"AK\u0017\u000e\u0003-R!\u0001\f\n\u0002\u0011M,7-\u001e:jifL!AL\u0016\u0003#A+'/\\5tg&|gn\u00115fG.,'/\u0001\u0007u_.,gnU3sm&\u001cW\r\u0005\u00022i5\t!G\u0003\u00024%\u000591/\u001a:wS\u000e,\u0017BA\u001b3\u0005A)6/\u001a:U_.,gnU3sm&\u001cW-A\u0003vg\u0016\u00148\u000f\u0005\u00022q%\u0011\u0011H\r\u0002\u0006+N,'o]\u0001\u0016aJLgnY5qC2$\u0015\r^1Qe>4\u0018\u000eZ3s!\tat(D\u0001>\u0015\tq$#A\u0007qe&t7-\u001b9bY\u0012\fG/Y\u0005\u0003\u0001v\u0012Q\u0003\u0015:j]\u000eL\u0007/\u00197ECR\f\u0007K]8wS\u0012,'/\u0001\u0004=S:LGO\u0010\u000b\u0006\u0007\u00163u\t\u0013\t\u0003\t\u0002i\u0011A\u0004\u0005\u0006Q\u0015\u0001\r!\u000b\u0005\u0006_\u0015\u0001\r\u0001\r\u0005\u0006m\u0015\u0001\ra\u000e\u0005\u0006u\u0015\u0001\ra\u000f\u0015\u0003\u000b)\u0003\"a\u0013,\u000e\u00031S!!\u0014(\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002P!\u00069a-Y2u_JL(BA)S\u0003\u0015\u0011W-\u00198t\u0015\t\u0019F+A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005)\u0016aA8sO&\u0011q\u000b\u0014\u0002\n\u0003V$xn^5sK\u0012\fQbZ3u+N,'\u000fV8lK:\u001cHc\u0001.h\u007fB\u00191\f\u00192\u000e\u0003qS!!\u00180\u0002\r\u0011|W.Y5o\u0015\ty&+\u0001\u0003eCR\f\u0017BA1]\u0005\u0011\u0001\u0016mZ3\u0011\u0005\r,W\"\u00013\u000b\u0005u\u0013\u0012B\u00014e\u0005%)6/\u001a:U_.,g\u000eC\u0003i\r\u0001\u0007\u0011.\u0001\u0003qC\u001e,\u0007CA\u000ek\u0013\tYGDA\u0002J]RDCaZ7xqB\u0011a.^\u0007\u0002_*\u0011\u0001/]\u0001\u0003eNT!A]:\u0002\u0005]\u001c(\"\u0001;\u0002\u000b)\fg/\u0019=\n\u0005Y|'AC)vKJL\b+\u0019:b[\u0006)a/\u00197vK\u0006\n\u0001\u000e\u000b\u0003hu^l\bC\u00018|\u0013\taxN\u0001\u0007EK\u001a\fW\u000f\u001c;WC2,X-I\u0001\u007f\u0003\u0005\u0001\u0004BBA\u0001\r\u0001\u0007\u0011.\u0001\bsKN,H\u000e^:QKJ\u0004\u0016mZ3)\u000b}lw/!\u0002\"\u0005\u0005\u0005\u0001&B@{o\u0006%\u0011EAA\u0006\u0003\r\t\u0004\u0007\r\u0015\u0004\r\u0005=\u0001\u0003BA\t\u0003;i!!a\u0005\u000b\u00075\u000b)B\u0003\u0003\u0002\u0018\u0005e\u0011aB7fiJL7m\u001d\u0006\u0004\u000371\u0012\u0001C2pI\u0006D\u0017\r\\3\n\t\u0005}\u00111\u0003\u0002\u0006)&lW\r\u001a\u0015\u0007\r\u0005\rr/!\u000b\u0011\u00079\f)#C\u0002\u0002(=\u0014A\u0001U1uQ\u0006\u0012\u00111F\u0001\u0007_U\u001cXM]:)\u0007\u0019\ty\u0003E\u0002o\u0003cI1!a\rp\u0005\r9U\tV\u0001\u0015O\u0016$Hk\\6f]N4uN]+tKJt\u0017-\\3\u0015\u000fi\u000bI$!\u0018\u0002d!9\u00111H\u0004A\u0002\u0005u\u0012\u0001C;tKJt\u0017-\\3\u0011\t\u0005}\u0012Q\n\b\u0005\u0003\u0003\nI\u0005E\u0002\u0002Dqi!!!\u0012\u000b\u0007\u0005\u001d\u0003$\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0017b\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002P\u0005E#AB*ue&twMC\u0002\u0002LqAs!!\u000f\u0002V]\fY\u0006E\u0002o\u0003/J1!!\u0017p\u0005%\u0001\u0016\r\u001e5QCJ\fW.\t\u0002\u0002<!)\u0001n\u0002a\u0001S\"*\u0011QL7xq\"*\u0011Q\f>x{\"1\u0011\u0011A\u0004A\u0002%Dc!a\u0019no\u0006\u0015\u0001FBA2u^\fI\u0001\u000b\u0004\b\u0003G9\u00181N\u0011\u0003\u0003[\n\u0011cL;tKJ\u001cxf_;tKJt\u0017-\\3~Q\r9\u0011qF\u0001\u0012O\u0016tWM]1uKV\u001bXM\u001d+pW\u0016tG#\u00022\u0002v\u0005e\u0004bBA\u001e\u0011\u0001\u0007\u0011Q\b\u0015\b\u0003k\n)f^A.\u0011\u001d\tY\b\u0003a\u0001\u0003{\nQ\"^:feR{7.\u001a8G_Jl\u0007\u0003BA@\u0003\u0013k!!!!\u000b\t\u0005\r\u0015QQ\u0001\u0006M>\u0014Xn\u001d\u0006\u0004\u0003\u000f\u0003\u0012A\u0001<2\u0013\u0011\tY)!!\u0003;\r\u0013X-\u0019;f!\u0016\u00148o\u001c8bY\u0006\u001b7-Z:t)>\\WM\u001c$pe6Dc\u0001CA\u0012o\u0006-\u0004f\u0001\u0005\u0002\u0012B\u0019a.a%\n\u0007\u0005UuN\u0001\u0003Q\u001fN#Fc\u00012\u0002\u001a\"9\u00111P\u0005A\u0002\u0005u\u0004fA\u0005\u0002\u0010!2\u0011\"a\tx\u0003SA3!CAI\u0003=!W\r\\3uKV\u001bXM\u001d+pW\u0016tG\u0003BAS\u0003W\u00032aGAT\u0013\r\tI\u000b\b\u0002\u0005+:LG\u000fC\u0004\u0002.*\u0001\r!a,\u0002\u000b\rLW+\u001b3\u0011\t\u0005E\u00161X\u0007\u0003\u0003gSA!!.\u00028\u0006!A.\u00198h\u0015\t\tI,\u0001\u0003kCZ\f\u0017\u0002BA_\u0003g\u0013q!\u00138uK\u001e,'\u000fK\u0004\u0002,\u0006Us/!1\"\u0005\u00055\u0006f\u0001\u0006\u0002\u0010!2!\"a\tx\u0003\u000f\f#!!3\u0002\u001d=*8/\u001a:t_m\u001c\u0017.V5e{\"\u001a!\"!4\u0011\u00079\fy-C\u0002\u0002R>\u0014a\u0001R#M\u000bR+\u0015!\t<bY&$\u0017\r^3B]\u0012tuN]7bY&TX-V:feR{7.\u001a8G_JlGCBAS\u0003/\fI\u000eC\u0004\u0002<-\u0001\r!!\u0010\t\u000f\u0005m4\u00021\u0001\u0002~Q9!,!8\u0002`\u0006\u0005\bbBA\u001e\u0019\u0001\u0007\u0011Q\b\u0005\u0006Q2\u0001\r!\u001b\u0005\u0007\u0003\u0003a\u0001\u0019A5)\u0007\u0001\t)\u000f\u0005\u0003\u0002h\u00065XBAAu\u0015\r\tYOU\u0001\u000bgR,'/Z8usB,\u0017\u0002BAx\u0003S\u0014!bQ8oiJ|G\u000e\\3sQ\u0019\u0001\u00111_<\u0002zB\u0019a.!>\n\u0007\u0005]xN\u0001\u0005Qe>$WoY3tY\t\tY0\t\u0002\u0002~\u0006\u0001\u0012\r\u001d9mS\u000e\fG/[8o_)\u001cxN\u001c\u0015\u0007\u0001\t\u0005qOa\u0002\u0011\u00079\u0014\u0019!C\u0002\u0003\u0006=\u0014\u0001bQ8ogVlWm\u001d\u0017\u0003\u0003wDc\u0001AA\u0012o\n-\u0011E\u0001B\u0007\u0003\u001dyCo\\6f]N\u0004")
public class UserTokenResource
implements Logging {
    private final PermissionChecker permissions;
    private final UserTokenService tokenService;
    private final Users users;
    private final PrincipalDataProvider principalDataProvider;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        UserTokenResource userTokenResource = this;
        synchronized (userTokenResource) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @GET
    @Path(value="/users")
    @Timed
    public Page<UserToken> getUserTokens(@DefaultValue(value="0") @QueryParam(value="page") int page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") int resultsPerPage) {
        return this.getUserTokens(User.AUTHENTICATED_USER.getName(), page, resultsPerPage);
    }

    @GET
    @Path(value="/users/{username}")
    public Page<UserToken> getTokensForUsername(@PathParam(value="username") String username, @DefaultValue(value="0") @QueryParam(value="page") int page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") int resultsPerPage) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.getUserTokens(username, page, resultsPerPage);
    }

    @POST
    @Path(value="/users/{username}")
    public UserToken generateUserToken(@PathParam(value="username") String username, CreatePersonalAccessTokenForm userTokenForm) {
        this.permissions.check(PlatformPermissions.ADMIN);
        Checks.checkArgument((boolean)this.users.userExistsInRepository(username), (String)"Personal access tokens generated by administrator are only supported for internal users", (Object[])new Object[0]);
        this.validateAndNormalizeUserTokenForm(username, userTokenForm);
        return this.tokenService.createUserToken(username, userTokenForm.getTokenNote(), userTokenForm.getExpiryDate());
    }

    @POST
    @Path(value="/users")
    @Timed
    public UserToken generateUserToken(CreatePersonalAccessTokenForm userTokenForm) {
        String username = User.AUTHENTICATED_USER.getName();
        UserData userData = this.principalDataProvider.getUserData(username);
        boolean personalAccessTokenSupported = this.users.userExistsInRepository(username) || userData.isFound();
        Checks.checkArgument((boolean)personalAccessTokenSupported, (String)"Personal access tokens are only supported for internal users and external users authenticated via LDAP, Atlassian Crowd", (Object[])new Object[0]);
        this.validateAndNormalizeUserTokenForm(username, userTokenForm);
        return this.tokenService.createUserToken(username, userTokenForm.getTokenNote(), userTokenForm.getExpiryDate());
    }

    @DELETE
    @Path(value="/users/{ciUid}")
    @Timed
    public void deleteUserToken(@PathParam(value="ciUid") Integer ciUid) {
        Option<UserToken> userToken = this.tokenService.findByCiUid(ciUid);
        Option<UserToken> option = userToken;
        if (option instanceof Some) {
            Some some = (Some)option;
            UserToken token = (UserToken)some.value();
            if (token.username().equalsIgnoreCase(User.AUTHENTICATED_USER.getName()) || this.permissions.isCurrentUserAdmin()) {
                this.tokenService.deleteUserToken(token);
                return;
            }
            throw new PermissionDeniedException("You don't have the permissions required to delete this personal access token.");
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException("Personal access token ciUid[" + ciUid + "] is not valid");
        }
        throw new MatchError(option);
    }

    private void validateAndNormalizeUserTokenForm(String username, CreatePersonalAccessTokenForm userTokenForm) {
        Checks.checkArgument((boolean)Strings.isNotBlank((String)userTokenForm.getTokenNote()), (String)"Note can't be blank", (Object[])new Object[0]);
        Checks.checkArgument((userTokenForm.getExpiryDate() == null || userTokenForm.getExpiryDate().getTime() > System.currentTimeMillis() ? 1 : 0) != 0, (String)"Expiry date is not valid", (Object[])new Object[0]);
        String tokenNote = userTokenForm.getTokenNote().trim();
        userTokenForm.setTokenNote(tokenNote);
        Checks.checkArgument((tokenNote.length() < 256 ? 1 : 0) != 0, (String)"Note must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!this.tokenService.userTokenExists(username, tokenNote) ? 1 : 0) != 0, (String)"Note has already been taken", (Object[])new Object[0]);
    }

    private Page<UserToken> getUserTokens(String username, int page, int resultsPerPage) {
        Checks.checkArgument(((long)resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than 100", (Object[])new Object[0]);
        PageRequest pageable = PageRequest.of((int)page, (int)resultsPerPage);
        return this.tokenService.find(username, (Pageable)pageable);
    }

    @Autowired
    public UserTokenResource(PermissionChecker permissions, UserTokenService tokenService, Users users, PrincipalDataProvider principalDataProvider) {
        this.permissions = permissions;
        this.tokenService = tokenService;
        this.users = users;
        this.principalDataProvider = principalDataProvider;
        Logging.$init$((Logging)this);
    }
}

