package com.xebialabs.xlrelease.script.groovy

import com.xebialabs.xlrelease.script.Jsr223EngineFactory
import grizzled.slf4j.Logging
import groovy.lang.{GroovyClassLoader, Script}
import org.codehaus.groovy.control.CompilerConfiguration
import org.codehaus.groovy.jsr223.GroovyScriptEngineImpl
import org.kohsuke.groovy.sandbox.SandboxTransformer
import org.springframework.stereotype.Component

import javax.script.ScriptEngine

@Component
class GroovyEngineInstance extends Logging with Jsr223EngineFactory {

  def getScriptEngine(restricted: Boolean): ScriptEngine = {
    val engine = createEngine(restricted)
    logger.debug(s"Groovy engine [restricted: $restricted] instance started.")
    engine
  }

  private def createEngine(restricted: Boolean): ScriptEngine = {
    if (restricted) {
      val secureConfig = new CompilerConfiguration
      secureConfig.addCompilationCustomizers(new SandboxTransformer)
      val groovyClassLoader = new GroovyClassLoader(getParentLoader, secureConfig)
      new GroovyScriptEngineImpl(groovyClassLoader)
    } else {
      new GroovyScriptEngineImpl()
    }
  }

  private def getParentLoader: ClassLoader = {
    // check whether thread context loader can "see" Groovy Script class
    val ctxtLoader = Thread.currentThread.getContextClassLoader
    try {
      val scriptClass = ctxtLoader.loadClass(classOf[Script].getName)
      //noinspection ScalaStyle
      if (scriptClass == classOf[Script]) return ctxtLoader
    } catch {
      case _: ClassNotFoundException => // ignore
    }
    // exception was thrown or we get wrong class
    classOf[Script].getClassLoader
  }
}
