package com.xebialabs.xlrelease.scheduler.events.handlers

import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import com.xebialabs.xlrelease.scheduler.JobQueue
import com.xebialabs.xlrelease.scheduler.events.{JobCreatedEvent, JobReservedEvent}
import grizzled.slf4j.Logging
import org.springframework.stereotype.Service

@Service
@EventListener
class JobEventHandler(jobQueue: JobQueue) extends Logging {

  @Subscribe
  def onJobReserved(jobReserved: JobReservedEvent): Unit = {
    logger.debug(s"removing job $jobReserved as it is reserved on another node")
    jobQueue.cancelIf(_.id == jobReserved.jobId)
  }

  @Subscribe
  def onJobCreated(jobCreatedEvent: JobCreatedEvent): Unit = {
    val job = jobCreatedEvent.job
    if (null != job) {
      logger.debug(s"submitting broadcasted job ${job.id}")
      jobQueue.submitBroadcasted(job)
    }
  }

}
