package com.xebialabs.xlrelease.domain.upgrade

import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.{JsonUpgrade, UpgradeResult}
import org.codehaus.jettison.json.{JSONArray, JSONObject}
import org.springframework.stereotype.Component

import java.util.Collections

@Component
class AttachmentReleaseBackreferenceJsonUpgrade extends JsonUpgrade {
  private val ATTACHMENTS = "attachments"
  private val PHASES = "phases"
  private val RELEASE = "release"
  private val TASKS = "tasks"

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "10.3.0#4")

  private def upgardeRelease(release: JSONObject): Unit = {
    upgradeObject(release, ATTACHMENTS, upgradeAttachments)
    upgradeObject(release, PHASES, upgradePhases)
  }

  private def upgradeArray(array: JSONArray, callback: JSONObject => Unit): Unit = {
    for (i <- 0 until array.length()) {
      array.get(i) match {
        case attachment: JSONObject => callback(attachment)
        case _ => ()
      }
    }
  }

  private def upgradeAttachments(attachments: JSONArray): Unit = upgradeArray(attachments, upgradeAttachment)

  private def upgradeAttachment(attachment: JSONObject): Unit = {
    if (attachment.has(RELEASE)) {
      attachment.remove(RELEASE)
    }
  }

  private def upgradePhases(phases: JSONArray): Unit = {
    for (i <- 0 until phases.length()) {
      phases.get(i) match {
        case phase: JSONObject => upgradePhase(phase)
      }
    }
  }

  private def upgradePhase(phase: JSONObject): Unit = {
    upgradeObject(phase, TASKS, upgradeTasks)
  }

  private def upgradeTasks(tasks: JSONArray): Unit = {
    for (i <- 0 until tasks.length()) {
      tasks.get(i) match {
        case task: JSONObject => upgradeTask(task)
      }
    }
  }

  private def upgradeTask(task: JSONObject): Unit = {
    upgradeObject(task, ATTACHMENTS, upgradeAttachments)
    upgradeObject(task, TASKS, upgradeTasks)
  }

  private def upgradeObject(json: JSONObject, key: String, callback: JSONArray => Unit): Unit = {
    if (json.has(key)) {
      json.get(key) match {
        case array: JSONArray => callback(array)
        case _ => ()
      }
    }
  }

  override def performUpgrade(release: JSONObject): UpgradeResult = {
    upgardeRelease(release)
    new UpgradeResult(true, Collections.emptyList())
  }

  /**
    * We are not going to do anything here, because it only causes the problem
    * during template import
    */
  override def doUpgrade(): Boolean = true
}
