package com.xebialabs.xlrelease.scheduler.workers

import com.xebialabs.xlrelease.actors.ReleaseActorService
import com.xebialabs.xlrelease.domain.ScriptTask.JYTHON_ENGINE
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.scheduler.FacetCheckJob
import com.xebialabs.xlrelease.scheduler.workers.Worker.ExecuteJob
import com.xebialabs.xlrelease.script.{AwaitFacetCheckResult, FailureFacetCheckResult, ScriptService, SuccessFacetCheckResult}
import org.springframework.stereotype.Component

@Component
class FacetCheckWorker(releaseActorService: ReleaseActorService,
                       val scriptServicesList: java.util.List[ScriptService])
  extends Worker with ScriptServiceSupport {
  override def execute: ExecuteJob = {
    case FacetCheckJob(taskRef) =>
      val task = taskRef.get()
      val r = scriptServices.get(JYTHON_ENGINE).executeFacetCheck(task)
      r match {
        case SuccessFacetCheckResult(taskId, executionId, executionLog, attachmentId, authentication) =>
          withAuthentication(authentication) {
            releaseActorService.taskPreconditionValidated(taskId, executionId)
          }
        case FailureFacetCheckResult(taskId, executionId, executionLog, attachmentId, authentication) =>
          withAuthentication(authentication) {
            releaseActorService.failScriptTask(taskId, executionLog, executionId, attachmentId, None)
          }
        case AwaitFacetCheckResult(taskId, executionId, executionLog, attachmentId, delayUntil, authentication) =>
          withAuthentication(authentication) {
            releaseActorService.postponeTaskUntilEnvironmentsAreReserved(Ids.releaseIdFrom(taskId), taskId, delayUntil, executionLog, executionId)
          }
      }
  }

}
