/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.logs;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.NoSerializationVerificationNeeded;
import akka.actor.ReceiveTimeout$;
import akka.actor.SupervisorStrategy;
import akka.annotation.InternalApi;
import akka.event.LoggingReceive$;
import akka.event.slf4j.SLF4JLogging;
import com.xebialabs.xlrelease.scheduler.logs.ExecutionLogWatchActor$;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionEntry;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionLogService;
import com.xebialabs.xlrelease.service.SseService;
import com.xebialabs.xlrelease.storage.domain.JobEntryRef;
import com.xebialabs.xlrelease.storage.domain.StorageEntryRef;
import com.xebialabs.xlrelease.storage.service.StorageService;
import com.xebialabs.xlrelease.support.akka.spring.SpringActor;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.time.Instant;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Using;
import scala.util.Using$;

@SpringActor
@ScalaSignature(bytes="\u0006\u0005\u0011\raaBA\u0005\u0003\u0017\u0001\u0011\u0011\u0005\u0005\u000b\u0003\u001f\u0002!\u0011!Q\u0001\n\u0005E\u0003BCA-\u0001\t\u0005\t\u0015!\u0003\u0002\\!Q\u00111\u000e\u0001\u0003\u0002\u0003\u0006I!!\u001c\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z!Y\u00111\u0011\u0001A\u0002\u0003\u0007I\u0011AAC\u0011-\ti\n\u0001a\u0001\u0002\u0004%\t!a(\t\u0017\u0005-\u0006\u00011A\u0001B\u0003&\u0011q\u0011\u0005\f\u0003[\u0003\u0001\u0019!a\u0001\n\u0003\t)\tC\u0006\u00020\u0002\u0001\r\u00111A\u0005\u0002\u0005E\u0006bCA[\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u000fC\u0011\"a.\u0001\u0001\u0004%\t!!/\t\u0013\u0005-\u0007\u00011A\u0005\u0002\u00055\u0007\u0002CAi\u0001\u0001\u0006K!a/\t\u000f\u0005M\u0007\u0001\"\u0011\u0002V\"9\u0011q\u001c\u0001\u0005B\u0005\u0005\bbBAr\u0001\u0011%\u0011Q\u001d\u0005\b\u0007G\u0004A\u0011BBs\u0011\u001d\u0019I\u000f\u0001C\u0005\u0007W<\u0001Ba\u0001\u0002\f!\u0005!Q\u0001\u0004\t\u0003\u0013\tY\u0001#\u0001\u0003\b!9\u0011q\u000f\u000b\u0005\u0002\t%\u0001\"\u0003B\u0006)\t\u0007IQAAC\u0011!\u0011i\u0001\u0006Q\u0001\u000e\u0005\u001d\u0005\"\u0003B\b)\t\u0007IQAAC\u0011!\u0011\t\u0002\u0006Q\u0001\u000e\u0005\u001d\u0005\"\u0003B\n)\t\u0007IQAAC\u0011!\u0011)\u0002\u0006Q\u0001\u000e\u0005\u001d\u0005\"\u0003B\f)\t\u0007IQAAC\u0011!\u0011I\u0002\u0006Q\u0001\u000e\u0005\u001de!\u0003B\u000e)A\u0005\u0019\u0013\u0005B\u000f\u0011\u001d\t\u0019I\bD\u0001\u0003\u000b3aAa=\u0015\u0001\nU\bBCAWA\tU\r\u0011\"\u0001\u0002\u0006\"Q\u0011Q\u0017\u0011\u0003\u0012\u0003\u0006I!a\"\t\u0015\u0005\r\u0005E!f\u0001\n\u0003\t)\t\u0003\u0006\u0002,\u0002\u0012\t\u0012)A\u0005\u0003\u000fC!B!@!\u0005+\u0007I\u0011AAC\u0011)\u0011y\u0010\tB\tB\u0003%\u0011q\u0011\u0005\b\u0003o\u0002C\u0011AB\u0001\u0011%\u00119\u0005IA\u0001\n\u0003\u0019Y\u0001C\u0005\u0003N\u0001\n\n\u0011\"\u0001\u0003P!I!Q\u001c\u0011\u0012\u0002\u0013\u0005!q\n\u0005\n\u0007'\u0001\u0013\u0013!C\u0001\u0005\u001fB\u0011B!\u001a!\u0003\u0003%\tEa\u001a\t\u0013\tM\u0004%!A\u0005\u0002\tU\u0004\"\u0003B?A\u0005\u0005I\u0011AB\u000b\u0011%\u0011I\tIA\u0001\n\u0003\u0012Y\tC\u0005\u0003\u001a\u0002\n\t\u0011\"\u0001\u0004\u001a!I!Q\u0015\u0011\u0002\u0002\u0013\u00053Q\u0004\u0005\n\u0005W\u0003\u0013\u0011!C!\u0005[C\u0011Ba,!\u0003\u0003%\tE!-\t\u0013\tM\u0006%!A\u0005B\r\u0005r!CB*)\u0005\u0005\t\u0012AB+\r%\u0011\u0019\u0010FA\u0001\u0012\u0003\u00199\u0006C\u0004\u0002xY\"\taa\u001c\t\u0013\t=f'!A\u0005F\tE\u0006\"CB9m\u0005\u0005I\u0011QB:\u0011%\u0019YHNA\u0001\n\u0003\u001bi\bC\u0005\u0004\fZ\n\t\u0011\"\u0003\u0004\u000e\u001a11Q\u0005\u000bA\u0007OA!\"a!=\u0005+\u0007I\u0011AAC\u0011)\tY\u000b\u0010B\tB\u0003%\u0011q\u0011\u0005\u000b\u0005{d$Q3A\u0005\u0002\r%\u0002B\u0003B\u0000y\tE\t\u0015!\u0003\u0004,!9\u0011q\u000f\u001f\u0005\u0002\rE\u0002\"\u0003B$y\u0005\u0005I\u0011AB\u001d\u0011%\u0011i\u0005PI\u0001\n\u0003\u0011y\u0005C\u0005\u0003^r\n\n\u0011\"\u0001\u0004@!I!Q\r\u001f\u0002\u0002\u0013\u0005#q\r\u0005\n\u0005gb\u0014\u0011!C\u0001\u0005kB\u0011B! =\u0003\u0003%\taa\u0011\t\u0013\t%E(!A\u0005B\t-\u0005\"\u0003BMy\u0005\u0005I\u0011AB$\u0011%\u0011)\u000bPA\u0001\n\u0003\u001aY\u0005C\u0005\u0003,r\n\t\u0011\"\u0011\u0003.\"I!q\u0016\u001f\u0002\u0002\u0013\u0005#\u0011\u0017\u0005\n\u0005gc\u0014\u0011!C!\u0007\u001f:\u0011b!&\u0015\u0003\u0003E\taa&\u0007\u0013\r\u0015B#!A\t\u0002\re\u0005bBA<\u001f\u0012\u00051\u0011\u0015\u0005\n\u0005_{\u0015\u0011!C#\u0005cC\u0011b!\u001dP\u0003\u0003%\tia)\t\u0013\rmt*!A\u0005\u0002\u000e%\u0006\"CBF\u001f\u0006\u0005I\u0011BBG\r\u0019\u0011\t\u0003\u0006!\u0003$!Q\u00111Q+\u0003\u0016\u0004%\t!!\"\t\u0015\u0005-VK!E!\u0002\u0013\t9\tC\u0004\u0002xU#\tA!\u0011\t\u0013\t\u001dS+!A\u0005\u0002\t%\u0003\"\u0003B'+F\u0005I\u0011\u0001B(\u0011%\u0011)'VA\u0001\n\u0003\u00129\u0007C\u0005\u0003tU\u000b\t\u0011\"\u0001\u0003v!I!QP+\u0002\u0002\u0013\u0005!q\u0010\u0005\n\u0005\u0013+\u0016\u0011!C!\u0005\u0017C\u0011B!'V\u0003\u0003%\tAa'\t\u0013\t\u0015V+!A\u0005B\t\u001d\u0006\"\u0003BV+\u0006\u0005I\u0011\tBW\u0011%\u0011y+VA\u0001\n\u0003\u0012\t\fC\u0005\u00034V\u000b\t\u0011\"\u0011\u00036\u001eI1Q\u0017\u000b\u0002\u0002#\u00051q\u0017\u0004\n\u0005C!\u0012\u0011!E\u0001\u0007sCq!a\u001ef\t\u0003\u0019\t\rC\u0005\u00030\u0016\f\t\u0011\"\u0012\u00032\"I1\u0011O3\u0002\u0002\u0013\u000551\u0019\u0005\n\u0007w*\u0017\u0011!CA\u0007\u000fD\u0011ba#f\u0003\u0003%Ia!$\u0007\r\teF\u0003\u0011B^\u0011)\t\u0019i\u001bBK\u0002\u0013\u0005\u0011Q\u0011\u0005\u000b\u0003W['\u0011#Q\u0001\n\u0005\u001d\u0005B\u0003B_W\nU\r\u0011\"\u0001\u0003@\"Q!QZ6\u0003\u0012\u0003\u0006IA!1\t\u000f\u0005]4\u000e\"\u0001\u0003P\"I!qI6\u0002\u0002\u0013\u0005!q\u001b\u0005\n\u0005\u001bZ\u0017\u0013!C\u0001\u0005\u001fB\u0011B!8l#\u0003%\tAa8\t\u0013\t\u00154.!A\u0005B\t\u001d\u0004\"\u0003B:W\u0006\u0005I\u0011\u0001B;\u0011%\u0011ih[A\u0001\n\u0003\u0011\u0019\u000fC\u0005\u0003\n.\f\t\u0011\"\u0011\u0003\f\"I!\u0011T6\u0002\u0002\u0013\u0005!q\u001d\u0005\n\u0005K[\u0017\u0011!C!\u0005WD\u0011Ba+l\u0003\u0003%\tE!,\t\u0013\t=6.!A\u0005B\tE\u0006\"\u0003BZW\u0006\u0005I\u0011\tBx\u000f%\u0019Y\rFA\u0001\u0012\u0003\u0019iMB\u0005\u0003:R\t\t\u0011#\u0001\u0004P\"9\u0011q\u000f@\u0005\u0002\rM\u0007\"\u0003BX}\u0006\u0005IQ\tBY\u0011%\u0019\tH`A\u0001\n\u0003\u001b)\u000eC\u0005\u0004|y\f\t\u0011\"!\u0004\\\"I11\u0012@\u0002\u0002\u0013%1Q\u0012\u0002\u0017\u000bb,7-\u001e;j_:dunZ,bi\u000eD\u0017i\u0019;pe*!\u0011QBA\b\u0003\u0011awnZ:\u000b\t\u0005E\u00111C\u0001\ng\u000eDW\rZ;mKJTA!!\u0006\u0002\u0018\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0005\u00033\tY\"A\u0005yK\nL\u0017\r\\1cg*\u0011\u0011QD\u0001\u0004G>l7\u0001A\n\b\u0001\u0005\r\u0012qFA !\u0011\t)#a\u000b\u000e\u0005\u0005\u001d\"BAA\u0015\u0003\u0015\u00198-\u00197b\u0013\u0011\ti#a\n\u0003\r\u0005s\u0017PU3g!\u0011\t\t$a\u000f\u000e\u0005\u0005M\"\u0002BA\u001b\u0003o\tQ!Y2u_JT!!!\u000f\u0002\t\u0005\\7.Y\u0005\u0005\u0003{\t\u0019DA\u0003BGR|'\u000f\u0005\u0003\u0002B\u0005-SBAA\"\u0015\u0011\t)%a\u0012\u0002\u000bMdg\r\u000e6\u000b\t\u0005%\u0013qG\u0001\u0006KZ,g\u000e^\u0005\u0005\u0003\u001b\n\u0019E\u0001\u0007T\u0019\u001a#$\nT8hO&tw-A\fuCN\\W\t_3dkRLwN\u001c'pON+'O^5dKB!\u00111KA+\u001b\t\tY!\u0003\u0003\u0002X\u0005-!a\u0006+bg.,\u00050Z2vi&|g\u000eT8h'\u0016\u0014h/[2f\u00039\u0019Ho\u001c:bO\u0016\u001cVM\u001d<jG\u0016\u0004B!!\u0018\u0002h5\u0011\u0011q\f\u0006\u0005\u0003C\n\u0019'A\u0004tKJ4\u0018nY3\u000b\t\u0005\u0015\u00141C\u0001\bgR|'/Y4f\u0013\u0011\tI'a\u0018\u0003\u001dM#xN]1hKN+'O^5dK\u0006Q1o]3TKJ4\u0018nY3\u0011\t\u0005=\u00141O\u0007\u0003\u0003cRA!!\u0019\u0002\u0014%!\u0011QOA9\u0005)\u00196/Z*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011\u0005m\u0014QPA@\u0003\u0003\u00032!a\u0015\u0001\u0011\u001d\ty\u0005\u0002a\u0001\u0003#Bq!!\u0017\u0005\u0001\u0004\tY\u0006C\u0004\u0002l\u0011\u0001\r!!\u001c\u0002\u0017\u0015DXmY;uS>t\u0017\nZ\u000b\u0003\u0003\u000f\u0003B!!#\u0002\u0018:!\u00111RAJ!\u0011\ti)a\n\u000e\u0005\u0005=%\u0002BAI\u0003?\ta\u0001\u0010:p_Rt\u0014\u0002BAK\u0003O\ta\u0001\u0015:fI\u00164\u0017\u0002BAM\u00037\u0013aa\u0015;sS:<'\u0002BAK\u0003O\tq\"\u001a=fGV$\u0018n\u001c8JI~#S-\u001d\u000b\u0005\u0003C\u000b9\u000b\u0005\u0003\u0002&\u0005\r\u0016\u0002BAS\u0003O\u0011A!\u00168ji\"I\u0011\u0011\u0016\u0004\u0002\u0002\u0003\u0007\u0011qQ\u0001\u0004q\u0012\n\u0014\u0001D3yK\u000e,H/[8o\u0013\u0012\u0004\u0013A\u0002;bg.LE-\u0001\u0006uCN\\\u0017\nZ0%KF$B!!)\u00024\"I\u0011\u0011V\u0005\u0002\u0002\u0003\u0007\u0011qQ\u0001\bi\u0006\u001c8.\u00133!\u0003Ia\u0017m\u001d;Fm\u0016tG\u000fV5nKN$\u0018-\u001c9\u0016\u0005\u0005m\u0006\u0003BA_\u0003\u000fl!!a0\u000b\t\u0005\u0005\u00171Y\u0001\u0005i&lWM\u0003\u0002\u0002F\u0006!!.\u0019<b\u0013\u0011\tI-a0\u0003\u000f%s7\u000f^1oi\u00061B.Y:u\u000bZ,g\u000e\u001e+j[\u0016\u001cH/Y7q?\u0012*\u0017\u000f\u0006\u0003\u0002\"\u0006=\u0007\"CAU\u0019\u0005\u0005\t\u0019AA^\u0003Ma\u0017m\u001d;Fm\u0016tG\u000fV5nKN$\u0018-\u001c9!\u0003\u001d\u0011XmY3jm\u0016,\"!a6\u0011\t\u0005e\u00171\\\u0007\u0002\u0001%!\u0011Q\\A\u001e\u0005\u001d\u0011VmY3jm\u0016\f\u0001\u0002]8tiN#x\u000e\u001d\u000b\u0003\u0003C\u000bq\u0002[1oI2,w+\u0019;dQ6\u001bxm\u001d\u000b\u0005\u0003C\u000b9\u000fC\u0004\u0002jB\u0001\r!a;\u0002\u0015]\fGo\u00195fe6\u001bx\rE\u0002\u0002nzq1!a<\u0014\u001d\u0011\t\tP!\u0001\u000f\t\u0005M\u0018q \b\u0005\u0003k\fiP\u0004\u0003\u0002x\u0006mh\u0002BAG\u0003sL!!!\b\n\t\u0005e\u00111D\u0005\u0005\u0003+\t9\"\u0003\u0003\u0002\u0012\u0005M\u0011\u0002BA\u0007\u0003\u001f\ta#\u0012=fGV$\u0018n\u001c8M_\u001e<\u0016\r^2i\u0003\u000e$xN\u001d\t\u0004\u0003'\"2c\u0001\u000b\u0002$Q\u0011!QA\u0001\u001e\u0019>;ul\u0011%V\u001d.{VI\u0014+S3~\u001b%+R!U\u000b\u0012{VIV#O)\u0006qBjT$`\u0007\"+fjS0F\u001dR\u0013\u0016lX\"S\u000b\u0006#V\tR0F-\u0016sE\u000bI\u0001\u000f!&suiX*T\u000b~+e+\u0012(U\u0003=\u0001\u0016JT$`'N+u,\u0012,F\u001dR\u0003\u0013!C#O\t~+e+\u0012(U\u0003))e\nR0F-\u0016sE\u000bI\u0001\u001b\u000bb+5)\u0016+J\u001f:{FjT$`'R\u000bE+V*`\u000bZ+e\nV\u0001\u001c\u000bb+5)\u0016+J\u001f:{FjT$`'R\u000bE+V*`\u000bZ+e\n\u0016\u0011\u0003\u0015]\u000bGo\u00195fe6\u001bxmE\u0002\u001f\u0003GISAH+lAq\u0012Qa\u00115fG.\u001c\u0012\"VA\u0012\u0005K\u0011ICa\f\u0011\u0007\t\u001db$D\u0001\u0015!\u0011\t)Ca\u000b\n\t\t5\u0012q\u0005\u0002\b!J|G-^2u!\u0011\u0011\tDa\u000f\u000f\t\tM\"q\u0007\b\u0005\u0003\u001b\u0013)$\u0003\u0002\u0002*%!!\u0011HA\u0014\u0003\u001d\u0001\u0018mY6bO\u0016LAA!\u0010\u0003@\ta1+\u001a:jC2L'0\u00192mK*!!\u0011HA\u0014)\u0011\u0011\u0019E!\u0012\u0011\u0007\t\u001dR\u000bC\u0004\u0002\u0004b\u0003\r!a\"\u0002\t\r|\u0007/\u001f\u000b\u0005\u0005\u0007\u0012Y\u0005C\u0005\u0002\u0004f\u0003\n\u00111\u0001\u0002\b\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B)U\u0011\t9Ia\u0015,\u0005\tU\u0003\u0003\u0002B,\u0005Cj!A!\u0017\u000b\t\tm#QL\u0001\nk:\u001c\u0007.Z2lK\u0012TAAa\u0018\u0002(\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\r$\u0011\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003jA!!1\u000eB9\u001b\t\u0011iG\u0003\u0003\u0003p\u0005\r\u0017\u0001\u00027b]\u001eLA!!'\u0003n\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011!q\u000f\t\u0005\u0003K\u0011I(\u0003\u0003\u0003|\u0005\u001d\"aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002BA\u0005\u000f\u0003B!!\n\u0003\u0004&!!QQA\u0014\u0005\r\te.\u001f\u0005\n\u0003Sk\u0016\u0011!a\u0001\u0005o\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005\u001b\u0003bAa$\u0003\u0016\n\u0005UB\u0001BI\u0015\u0011\u0011\u0019*a\n\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u0018\nE%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BA!(\u0003$B!\u0011Q\u0005BP\u0013\u0011\u0011\t+a\n\u0003\u000f\t{w\u000e\\3b]\"I\u0011\u0011V0\u0002\u0002\u0003\u0007!\u0011Q\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0003j\t%\u0006\"CAUA\u0006\u0005\t\u0019\u0001B<\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B<\u0003!!xn\u0015;sS:<GC\u0001B5\u0003\u0019)\u0017/^1mgR!!Q\u0014B\\\u0011%\tIkYA\u0001\u0002\u0004\u0011\tI\u0001\u0005OK^,e\u000e\u001e:z'%Y\u00171\u0005B\u0013\u0005S\u0011y#A\u0006oK^,e\u000e\u001e:z+JLWC\u0001Ba!\u0011\u0011\u0019M!3\u000e\u0005\t\u0015'\u0002\u0002Bd\u0003\u0007\f1A\\3u\u0013\u0011\u0011YM!2\u0003\u0007U\u0013\u0016*\u0001\u0007oK^,e\u000e\u001e:z+JL\u0007\u0005\u0006\u0004\u0003R\nM'Q\u001b\t\u0004\u0005OY\u0007bBABa\u0002\u0007\u0011q\u0011\u0005\b\u0005{\u0003\b\u0019\u0001Ba)\u0019\u0011\tN!7\u0003\\\"I\u00111Q9\u0011\u0002\u0003\u0007\u0011q\u0011\u0005\n\u0005{\u000b\b\u0013!a\u0001\u0005\u0003\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003b*\"!\u0011\u0019B*)\u0011\u0011\tI!:\t\u0013\u0005%f/!AA\u0002\t]D\u0003\u0002BO\u0005SD\u0011\"!+y\u0003\u0003\u0005\rA!!\u0015\t\t%$Q\u001e\u0005\n\u0003SK\u0018\u0011!a\u0001\u0005o\"BA!(\u0003r\"I\u0011\u0011\u0016?\u0002\u0002\u0003\u0007!\u0011\u0011\u0002\u000b'R\f'\u000f^,bi\u000eD7c\u0003\u0011\u0002$\t\u0015\"q\u001fB\u0015\u0005_\u0001B!!\r\u0003z&!!1`A\u001a\u0005\u0005runU3sS\u0006d\u0017N_1uS>tg+\u001a:jM&\u001c\u0017\r^5p]:+W\rZ3e\u0003!)8/\u001a:oC6,\u0017!C;tKJt\u0017-\\3!)!\u0019\u0019a!\u0002\u0004\b\r%\u0001c\u0001B\u0014A!9\u0011QV\u0014A\u0002\u0005\u001d\u0005bBABO\u0001\u0007\u0011q\u0011\u0005\b\u0005{<\u0003\u0019AAD)!\u0019\u0019a!\u0004\u0004\u0010\rE\u0001\"CAWQA\u0005\t\u0019AAD\u0011%\t\u0019\t\u000bI\u0001\u0002\u0004\t9\tC\u0005\u0003~\"\u0002\n\u00111\u0001\u0002\b\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aD\u0003\u0002BA\u0007/A\u0011\"!+/\u0003\u0003\u0005\rAa\u001e\u0015\t\tu51\u0004\u0005\n\u0003S\u0003\u0014\u0011!a\u0001\u0005\u0003#BA!\u001b\u0004 !I\u0011\u0011V\u0019\u0002\u0002\u0003\u0007!q\u000f\u000b\u0005\u0005;\u001b\u0019\u0003C\u0005\u0002*R\n\t\u00111\u0001\u0003\u0002\na1\u000b^8q/\u0006$8\r[5oONIA(a\t\u0003&\t%\"qF\u000b\u0003\u0007W\u0001b!!\n\u0004.\u0005\u001d\u0015\u0002BB\u0018\u0003O\u0011aa\u00149uS>tGCBB\u001a\u0007k\u00199\u0004E\u0002\u0003(qBq!a!B\u0001\u0004\t9\tC\u0004\u0003~\u0006\u0003\raa\u000b\u0015\r\rM21HB\u001f\u0011%\t\u0019I\u0011I\u0001\u0002\u0004\t9\tC\u0005\u0003~\n\u0003\n\u00111\u0001\u0004,U\u00111\u0011\t\u0016\u0005\u0007W\u0011\u0019\u0006\u0006\u0003\u0003\u0002\u000e\u0015\u0003\"CAU\u000f\u0006\u0005\t\u0019\u0001B<)\u0011\u0011ij!\u0013\t\u0013\u0005%\u0016*!AA\u0002\t\u0005E\u0003\u0002B5\u0007\u001bB\u0011\"!+K\u0003\u0003\u0005\rAa\u001e\u0015\t\tu5\u0011\u000b\u0005\n\u0003Sk\u0015\u0011!a\u0001\u0005\u0003\u000b!b\u0015;beR<\u0016\r^2i!\r\u00119CN\n\u0006m\re3Q\r\t\r\u00077\u001a\t'a\"\u0002\b\u0006\u001d51A\u0007\u0003\u0007;RAaa\u0018\u0002(\u00059!/\u001e8uS6,\u0017\u0002BB2\u0007;\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84!\u0011\u00199g!\u001c\u000e\u0005\r%$\u0002BB6\u0003\u0007\f!![8\n\t\tu2\u0011\u000e\u000b\u0003\u0007+\nQ!\u00199qYf$\u0002ba\u0001\u0004v\r]4\u0011\u0010\u0005\b\u0003[K\u0004\u0019AAD\u0011\u001d\t\u0019)\u000fa\u0001\u0003\u000fCqA!@:\u0001\u0004\t9)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r}4q\u0011\t\u0007\u0003K\u0019ic!!\u0011\u0015\u0005\u001521QAD\u0003\u000f\u000b9)\u0003\u0003\u0004\u0006\u0006\u001d\"A\u0002+va2,7\u0007C\u0005\u0004\nj\n\t\u00111\u0001\u0004\u0004\u0005\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\r=\u0005\u0003\u0002B6\u0007#KAaa%\u0003n\t1qJ\u00196fGR\fAb\u0015;pa^\u000bGo\u00195j]\u001e\u00042Aa\nP'\u0015y51TB3!)\u0019Yf!(\u0002\b\u000e-21G\u0005\u0005\u0007?\u001biFA\tBEN$(/Y2u\rVt7\r^5p]J\"\"aa&\u0015\r\rM2QUBT\u0011\u001d\t\u0019I\u0015a\u0001\u0003\u000fCqA!@S\u0001\u0004\u0019Y\u0003\u0006\u0003\u0004,\u000eM\u0006CBA\u0013\u0007[\u0019i\u000b\u0005\u0005\u0002&\r=\u0016qQB\u0016\u0013\u0011\u0019\t,a\n\u0003\rQ+\b\u000f\\33\u0011%\u0019IiUA\u0001\u0002\u0004\u0019\u0019$A\u0003DQ\u0016\u001c7\u000eE\u0002\u0003(\u0015\u001cR!ZB^\u0007K\u0002\u0002ba\u0017\u0004>\u0006\u001d%1I\u0005\u0005\u0007\u007f\u001biFA\tBEN$(/Y2u\rVt7\r^5p]F\"\"aa.\u0015\t\t\r3Q\u0019\u0005\b\u0003\u0007C\u0007\u0019AAD)\u0011\u0019Yc!3\t\u0013\r%\u0015.!AA\u0002\t\r\u0013\u0001\u0003(fo\u0016sGO]=\u0011\u0007\t\u001dbpE\u0003\u007f\u0007#\u001c)\u0007\u0005\u0006\u0004\\\ru\u0015q\u0011Ba\u0005#$\"a!4\u0015\r\tE7q[Bm\u0011!\t\u0019)a\u0001A\u0002\u0005\u001d\u0005\u0002\u0003B_\u0003\u0007\u0001\rA!1\u0015\t\ru7\u0011\u001d\t\u0007\u0003K\u0019ica8\u0011\u0011\u0005\u00152qVAD\u0005\u0003D!b!#\u0002\u0006\u0005\u0005\t\u0019\u0001Bi\u0003I\u0019HO]3b[\u000e+(O]3oiN#\u0018\r^3\u0015\t\u0005\u00056q\u001d\u0005\b\u0003\u0007\u000b\u0002\u0019AAD\u0003=\u0019HO]3b[2\u000b7\u000f^\"ik:\\G\u0003BAQ\u0007[Dq!a!\u0013\u0001\u0004\t9\tK\u0002\u0001\u0007c\u0004Baa=\u0004\u00006\u00111Q\u001f\u0006\u0005\u0007o\u001cI0\u0001\u0004taJLgn\u001a\u0006\u0005\u0003s\u0019YP\u0003\u0003\u0004~\u0006M\u0011aB:vaB|'\u000f^\u0005\u0005\t\u0003\u0019)PA\u0006TaJLgnZ!di>\u0014\b")
public class ExecutionLogWatchActor
implements Actor,
SLF4JLogging {
    private final TaskExecutionLogService taskExecutionLogService;
    private final StorageService storageService;
    private final SseService sseService;
    private String executionId;
    private String taskId;
    private Instant lastEventTimestamp;
    private transient Logger log;
    private ActorContext context;
    private ActorRef self;
    private volatile transient boolean bitmap$trans$0;

    public static String EXECUTION_LOG_STATUS_EVENT() {
        return ExecutionLogWatchActor$.MODULE$.EXECUTION_LOG_STATUS_EVENT();
    }

    public static String END_EVENT() {
        return ExecutionLogWatchActor$.MODULE$.END_EVENT();
    }

    public static String PING_SSE_EVENT() {
        return ExecutionLogWatchActor$.MODULE$.PING_SSE_EVENT();
    }

    public static String LOG_CHUNK_ENTRY_CREATED_EVENT() {
        return ExecutionLogWatchActor$.MODULE$.LOG_CHUNK_ENTRY_CREATED_EVENT();
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preStart() throws Exception {
        Actor.preStart$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    private Logger log$lzycompute() {
        ExecutionLogWatchActor executionLogWatchActor = this;
        synchronized (executionLogWatchActor) {
            if (!this.bitmap$trans$0) {
                this.log = SLF4JLogging.log$((SLF4JLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public String executionId() {
        return this.executionId;
    }

    public void executionId_$eq(String x$1) {
        this.executionId = x$1;
    }

    public String taskId() {
        return this.taskId;
    }

    public void taskId_$eq(String x$1) {
        this.taskId = x$1;
    }

    public Instant lastEventTimestamp() {
        return this.lastEventTimestamp;
    }

    public void lastEventTimestamp_$eq(Instant x$1) {
        this.lastEventTimestamp = x$1;
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return LoggingReceive$.MODULE$.apply((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutionLogWatchActor $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof WatcherMsg) {
                    WatcherMsg watcherMsg = (WatcherMsg)A1;
                    this.$outer.com$xebialabs$xlrelease$scheduler$logs$ExecutionLogWatchActor$$handleWatchMsgs(watcherMsg);
                    return (B1)BoxedUnit.UNIT;
                }
                if (ReceiveTimeout$.MODULE$.equals(A1)) {
                    this.$outer.self().$bang((Object)new Check(this.$outer.executionId()), this.$outer.self());
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (object instanceof WatcherMsg) {
                    return true;
                }
                return ReceiveTimeout$.MODULE$.equals(object);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.context());
    }

    public void postStop() {
        if (this.executionId() != null) {
            this.sseService.sendEvent(this.executionId(), ExecutionLogWatchActor$.MODULE$.END_EVENT(), "");
            this.sseService.unsubscribeAllUsers(this.executionId());
            return;
        }
    }

    public void com$xebialabs$xlrelease$scheduler$logs$ExecutionLogWatchActor$$handleWatchMsgs(WatcherMsg watcherMsg) {
        boolean bl = false;
        StopWatching stopWatching = null;
        WatcherMsg watcherMsg2 = watcherMsg;
        if (watcherMsg2 instanceof StartWatch) {
            StartWatch startWatch = (StartWatch)watcherMsg2;
            String taskId = startWatch.taskId();
            String executionId = startWatch.executionId();
            String username = startWatch.username();
            this.executionId_$eq(executionId);
            this.taskId_$eq(taskId);
            this.sseService.subscribeTopicToUser(executionId, username);
            this.streamCurrentState(executionId);
            this.streamLastChunk(executionId);
            this.self().$bang((Object)new Check(executionId), this.self());
            return;
        }
        if (watcherMsg2 instanceof StopWatching) {
            bl = true;
            stopWatching = (StopWatching)watcherMsg2;
            String executionId = stopWatching.executionId();
            Option<String> option = stopWatching.username();
            if (option instanceof Some) {
                Some some = (Some)option;
                String username = (String)some.value();
                this.sseService.unsubscribeTopicToUser(executionId, username);
                this.self().$bang((Object)new Check(executionId), this.self());
                return;
            }
        }
        if (bl) {
            String executionId = stopWatching.executionId();
            Option<String> option = stopWatching.username();
            if (None$.MODULE$.equals(option)) {
                this.sseService.sendEvent(executionId, ExecutionLogWatchActor$.MODULE$.END_EVENT(), "");
                this.sseService.unsubscribeAllUsers(executionId);
                this.self().$bang((Object)new Check(executionId), this.self());
                return;
            }
        }
        if (watcherMsg2 instanceof Check) {
            Check check = (Check)watcherMsg2;
            String executionId = check.executionId();
            boolean hasUsersFollowingExecution = this.sseService.hasActiveUsers(executionId);
            if (!hasUsersFollowingExecution) {
                this.context().stop(this.self());
                return;
            }
            Option<TaskExecutionEntry> maybeExecutionEntry = this.taskExecutionLogService.getTaskExecutionEntry(this.taskId(), executionId);
            boolean executionIsCompletedOrMissing = maybeExecutionEntry.forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ExecutionLogWatchActor.$anonfun$handleWatchMsgs$1(x$3)));
            if (executionIsCompletedOrMissing) {
                this.self().$bang((Object)new StopWatching(executionId, (Option<String>)None$.MODULE$), this.self());
                return;
            }
            long durationSinceLastEvent = java.time.Duration.between(this.lastEventTimestamp(), Instant.now()).toSeconds();
            if (durationSinceLastEvent > 10L && durationSinceLastEvent < 60L) {
                this.sseService.sendEvent(executionId, ExecutionLogWatchActor$.MODULE$.PING_SSE_EVENT(), new String(":\n\n"));
                return;
            }
            if (durationSinceLastEvent >= 60L) {
                this.self().$bang((Object)new StopWatching(executionId, (Option<String>)None$.MODULE$), this.self());
                return;
            }
            return;
        }
        if (watcherMsg2 instanceof NewEntry) {
            NewEntry newEntry = (NewEntry)watcherMsg2;
            String executionId = newEntry.executionId();
            URI newEntryUri = newEntry.newEntryUri();
            this.lastEventTimestamp_$eq(Instant.now());
            byte[] payload = (byte[])Using$.MODULE$.resource((Object)this.storageService.get((StorageEntryRef)new JobEntryRef(newEntryUri)), (Function1 & Serializable)content -> IOUtils.toByteArray((InputStream)content), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            this.sseService.sendEvent(executionId, ExecutionLogWatchActor$.MODULE$.LOG_CHUNK_ENTRY_CREATED_EVENT(), new String(payload));
            return;
        }
        throw new MatchError((Object)watcherMsg2);
    }

    private void streamCurrentState(String executionId) {
        Tuple3 tuple3;
        Option<TaskExecutionEntry> option = this.taskExecutionLogService.getTaskExecutionEntry(this.taskId(), executionId);
        if (option instanceof Some) {
            Some some = (Some)option;
            TaskExecutionEntry row = (TaskExecutionEntry)some.value();
            tuple3 = new Tuple3((Object)(row.endDate() == null ? "in_progress" : "closed"), (Object)BoxesRunTime.boxToInteger((int)row.lastJob()), (Object)BoxesRunTime.boxToInteger((int)row.lastChunk()));
        } else if (None$.MODULE$.equals(option)) {
            tuple3 = new Tuple3((Object)"unknown", (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToInteger((int)-1));
        } else {
            throw new MatchError(option);
        }
        Tuple3 tuple32 = tuple3;
        if (tuple32 == null) {
            throw new MatchError((Object)tuple32);
        }
        String status = (String)tuple32._1();
        int jobId = BoxesRunTime.unboxToInt((Object)tuple32._2());
        int chunk = BoxesRunTime.unboxToInt((Object)tuple32._3());
        Tuple3 tuple33 = new Tuple3((Object)status, (Object)BoxesRunTime.boxToInteger((int)jobId), (Object)BoxesRunTime.boxToInteger((int)chunk));
        String status2 = (String)tuple33._1();
        int jobId2 = BoxesRunTime.unboxToInt((Object)tuple33._2());
        int chunk2 = BoxesRunTime.unboxToInt((Object)tuple33._3());
        String payload = status2 + ", " + jobId2 + ", " + chunk2;
        this.sseService.sendEvent(executionId, ExecutionLogWatchActor$.MODULE$.EXECUTION_LOG_STATUS_EVENT(), new String(payload));
    }

    private void streamLastChunk(String executionId) {
        Option<TaskExecutionEntry> maybeRow = this.taskExecutionLogService.getTaskExecutionEntry(this.taskId(), executionId);
        maybeRow.foreach((Function1 & Serializable)row -> {
            ExecutionLogWatchActor.$anonfun$streamLastChunk$1(this, row);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$handleWatchMsgs$1(TaskExecutionEntry x$3) {
        return x$3.endDate() != null;
    }

    public static final /* synthetic */ void $anonfun$streamLastChunk$1(ExecutionLogWatchActor $this, TaskExecutionEntry row) {
        String taskIdHash = row.taskIdHash();
        String executionId = row.executionId();
        int jobId = row.lastJob();
        int chunk = row.lastChunk();
        String uriPath = "/jobs/" + taskIdHash + "/" + executionId + "/" + jobId + "/" + chunk;
        String uriScheme = "xlr-local";
        URI entryUri = URI.create(uriScheme + "://" + uriPath);
        byte[] payload = (byte[])Using$.MODULE$.resource((Object)$this.storageService.get((StorageEntryRef)new JobEntryRef(entryUri)), (Function1 & Serializable)content -> IOUtils.toByteArray((InputStream)content), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        $this.sseService.sendEvent(executionId, ExecutionLogWatchActor$.MODULE$.LOG_CHUNK_ENTRY_CREATED_EVENT(), new String(payload));
    }

    public ExecutionLogWatchActor(TaskExecutionLogService taskExecutionLogService, StorageService storageService, SseService sseService) {
        this.taskExecutionLogService = taskExecutionLogService;
        this.storageService = storageService;
        this.sseService = sseService;
        Actor.$init$((Actor)this);
        SLF4JLogging.$init$((SLF4JLogging)this);
        this.lastEventTimestamp = Instant.now();
        this.context().setReceiveTimeout((Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds());
        Statics.releaseFence();
    }

    public static class Check
    implements WatcherMsg,
    Product,
    Serializable {
        private final String executionId;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public String executionId() {
            return this.executionId;
        }

        public Check copy(String executionId) {
            return new Check(executionId);
        }

        public String copy$default$1() {
            return this.executionId();
        }

        public String productPrefix() {
            return "Check";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.executionId();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Check;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "executionId";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Check)) return false;
            boolean bl = true;
            if (!bl) return false;
            Check check = (Check)x$1;
            String string = this.executionId();
            String string2 = check.executionId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!check.canEqual(this)) return false;
            return true;
        }

        public Check(String executionId) {
            this.executionId = executionId;
            Product.$init$((Product)this);
        }
    }

    public static class NewEntry
    implements WatcherMsg,
    Product,
    Serializable {
        private final String executionId;
        private final URI newEntryUri;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public String executionId() {
            return this.executionId;
        }

        public URI newEntryUri() {
            return this.newEntryUri;
        }

        public NewEntry copy(String executionId, URI newEntryUri) {
            return new NewEntry(executionId, newEntryUri);
        }

        public String copy$default$1() {
            return this.executionId();
        }

        public URI copy$default$2() {
            return this.newEntryUri();
        }

        public String productPrefix() {
            return "NewEntry";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.executionId();
                }
                case 1: {
                    return this.newEntryUri();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof NewEntry;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "executionId";
                }
                case 1: {
                    return "newEntryUri";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof NewEntry)) return false;
            boolean bl = true;
            if (!bl) return false;
            NewEntry newEntry = (NewEntry)x$1;
            String string = this.executionId();
            String string2 = newEntry.executionId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            URI uRI = this.newEntryUri();
            URI uRI2 = newEntry.newEntryUri();
            if (uRI == null) {
                if (uRI2 != null) {
                    return false;
                }
            } else if (!((Object)uRI).equals(uRI2)) return false;
            if (!newEntry.canEqual(this)) return false;
            return true;
        }

        public NewEntry(String executionId, URI newEntryUri) {
            this.executionId = executionId;
            this.newEntryUri = newEntryUri;
            Product.$init$((Product)this);
        }
    }

    public static class StartWatch
    implements WatcherMsg,
    NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final String taskId;
        private final String executionId;
        private final String username;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String taskId() {
            return this.taskId;
        }

        @Override
        public String executionId() {
            return this.executionId;
        }

        public String username() {
            return this.username;
        }

        public StartWatch copy(String taskId, String executionId, String username) {
            return new StartWatch(taskId, executionId, username);
        }

        public String copy$default$1() {
            return this.taskId();
        }

        public String copy$default$2() {
            return this.executionId();
        }

        public String copy$default$3() {
            return this.username();
        }

        public String productPrefix() {
            return "StartWatch";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.taskId();
                }
                case 1: {
                    return this.executionId();
                }
                case 2: {
                    return this.username();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof StartWatch;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "taskId";
                }
                case 1: {
                    return "executionId";
                }
                case 2: {
                    return "username";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof StartWatch)) return false;
            boolean bl = true;
            if (!bl) return false;
            StartWatch startWatch = (StartWatch)x$1;
            String string = this.taskId();
            String string2 = startWatch.taskId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.executionId();
            String string4 = startWatch.executionId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.username();
            String string6 = startWatch.username();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            if (!startWatch.canEqual(this)) return false;
            return true;
        }

        public StartWatch(String taskId, String executionId, String username) {
            this.taskId = taskId;
            this.executionId = executionId;
            this.username = username;
            Product.$init$((Product)this);
        }
    }

    public static class StopWatching
    implements WatcherMsg,
    Product,
    Serializable {
        private final String executionId;
        private final Option<String> username;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public String executionId() {
            return this.executionId;
        }

        public Option<String> username() {
            return this.username;
        }

        public StopWatching copy(String executionId, Option<String> username) {
            return new StopWatching(executionId, username);
        }

        public String copy$default$1() {
            return this.executionId();
        }

        public Option<String> copy$default$2() {
            return this.username();
        }

        public String productPrefix() {
            return "StopWatching";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.executionId();
                }
                case 1: {
                    return this.username();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof StopWatching;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "executionId";
                }
                case 1: {
                    return "username";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof StopWatching)) return false;
            boolean bl = true;
            if (!bl) return false;
            StopWatching stopWatching = (StopWatching)x$1;
            String string = this.executionId();
            String string2 = stopWatching.executionId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<String> option = this.username();
            Option<String> option2 = stopWatching.username();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!stopWatching.canEqual(this)) return false;
            return true;
        }

        public StopWatching(String executionId, Option<String> username) {
            this.executionId = executionId;
            this.username = username;
            Product.$init$((Product)this);
        }
    }

    public static interface WatcherMsg {
        public String executionId();
    }
}

