package com.xebialabs.xlrelease.features.settings

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.xlrelease.configuration.FeatureSettings
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty

import scala.beans.BeanProperty

@Metadata(label = "Release load options",
  description = "Flags related to release read operations")
class ReleaseLoadingFeatureSettings extends FeatureSettings {

  @BeanProperty
  @XLProperty(defaultValue = "Incubating", isTransient = true, hidden = true, readonly = true)
  var category: String = _

  @BeanProperty
  @XLProperty(label = "Batch load dependencies", description = "Enable batch loading of dependencies", category = "input", defaultValue = "true")
  var batchLoadDependencies: Boolean = _
}
